/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.workers;

import com.adventnet.snmp.beans.DataException;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.unit.SnmpBSTarget;
import com.brennenstuhl.workers.AbstractBsSnmpHandler;
import java.util.HashMap;
import java.util.Map;

public class RelayStateChanger
extends AbstractBsSnmpHandler {
    private final String OFF = "0";
    private final String ON = "1";
    private static Map<String, String> oids = new HashMap<String, String>();

    static {
        oids.put("relay1", "iso.org.dod.internet.private.enterprises.nbs.ws_brs.relay.relay1.0");
        oids.put("relay2", "iso.org.dod.internet.private.enterprises.nbs.ws_brs.relay.relay2.0");
    }

    public RelayStateChanger(Board board) {
        super(board);
    }

    private void switchStateRelay(String relay, String state) throws DataException {
        SnmpBSTarget target = new SnmpBSTarget(this.getBoard());
        target.setMibOperations(RelayStateChanger.getMibOperations());
        target.setObjectID(oids.get(relay));
        target.snmpSet(state);
    }

    public void switchRelay1(boolean switchOn) throws DataException {
        this.switchStateRelay("relay1", switchOn ? "1" : "0");
    }

    public void switchRelay2(boolean switchOn) throws DataException {
        this.switchStateRelay("relay2", switchOn ? "1" : "0");
    }
}

