/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.unit;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BootPPackage {
    private byte op;
    private byte hType;
    private byte hLen;
    private byte hops;
    private int xID;
    private short secs;
    private short flags;
    private byte[] ciAddr = new byte[4];
    private byte[] yiAddr = new byte[4];
    private byte[] siAddr = new byte[4];
    private byte[] giAddr = new byte[4];
    private byte[] cHAddr = new byte[16];
    private byte[] serverName = new byte[64];
    private byte[] file = new byte[128];
    private byte[] vendor = new byte[64];

    public BootPPackage(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.op = bb.get();
        this.hType = bb.get();
        this.hLen = bb.get();
        this.hops = bb.get();
        this.xID = bb.getInt();
        this.secs = bb.getShort();
        this.flags = bb.getShort();
        bb.get(this.ciAddr);
        bb.get(this.yiAddr);
        bb.get(this.siAddr);
        bb.get(this.giAddr);
        bb.get(this.cHAddr);
        bb.get(this.serverName);
        bb.get(this.file);
        bb.get(this.vendor);
    }

    public ByteBuffer getBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(300);
        bb.put(this.op);
        bb.put(this.hType);
        bb.put(this.hLen);
        bb.put(this.hops);
        bb.putInt(this.xID);
        bb.putShort(this.secs);
        bb.putShort(this.flags);
        bb.put(this.ciAddr);
        bb.put(this.yiAddr);
        bb.put(this.siAddr);
        bb.put(this.giAddr);
        bb.put(this.cHAddr);
        bb.put(this.serverName);
        bb.put(this.file);
        bb.put(this.vendor);
        bb.flip();
        return bb;
    }

    public byte getOp() {
        return this.op;
    }

    public void setOp(byte op) {
        this.op = op;
    }

    public byte gethType() {
        return this.hType;
    }

    public void sethType(byte hType) {
        this.hType = hType;
    }

    public byte gethLen() {
        return this.hLen;
    }

    public void sethLen(byte hLen) {
        this.hLen = hLen;
    }

    public byte getHops() {
        return this.hops;
    }

    public void setHops(byte hops) {
        this.hops = hops;
    }

    public int getxID() {
        return this.xID;
    }

    public void setxID(int xID) {
        this.xID = xID;
    }

    public short getSecs() {
        return this.secs;
    }

    public void setSecs(short secs) {
        this.secs = secs;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public byte[] getCiAddr() {
        return this.ciAddr;
    }

    public void setCiAddr(byte[] ciAddr) {
        this.ciAddr = ciAddr;
    }

    public byte[] getYiAddr() {
        return this.yiAddr;
    }

    public void setYiAddr(byte[] yiAddr) {
        this.yiAddr = yiAddr;
    }

    public byte[] getSiAddr() {
        return this.siAddr;
    }

    public void setSiAddr(byte[] siAddr) {
        this.siAddr = siAddr;
    }

    public byte[] getGiAddr() {
        return this.giAddr;
    }

    public void setGiAddr(byte[] giAddr) {
        this.giAddr = giAddr;
    }

    public byte[] getcHAddr() {
        return this.cHAddr;
    }

    public void setcHAddr(byte[] cHAddr) {
        this.cHAddr = cHAddr;
    }

    public String getServerName() {
        String rc;
        try {
            rc = new String(this.serverName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        return rc;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName.getBytes();
    }

    public byte[] getFile() {
        return this.file;
    }

    public String getFileAsString() {
        return new String(this.file);
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public byte[] getVendor() {
        return this.vendor;
    }

    public void setVendor(byte[] vendor) {
        this.vendor = vendor;
    }
}

