/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.thread;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.unit.SnmpBSTarget;
import com.brennenstuhl.unit.SnmpCommunitySettingsWrapper;
import com.brennenstuhl.utils.Constants;
import com.brennenstuhl.workers.AbstractBsSnmpHandler;

public class SnmpBoardHandler
extends AbstractBsSnmpHandler
implements Runnable {
    private volatile boolean bStopThread = false;
    private volatile boolean bPausedThread = false;
    private static String[] oidString = new String[]{"iso.org.dod.internet.private.enterprises.nbs.ws_brs.relay.relay1.0", "iso.org.dod.internet.private.enterprises.nbs.ws_brs.relay.relay2.0", "iso.org.dod.internet.private.enterprises.nbs.ws_brs.power.powerval.0"};

    public SnmpBoardHandler(Board board) {
        super(board);
        this.checkSnmpCommunity(board);
    }

    private void checkSnmpCommunity(Board board) {
        String[] comms = new SnmpCommunitySettingsWrapper().getCommunities();
        SnmpBSTarget target = new SnmpBSTarget(this.getBoard());
        target.setMibOperations(SnmpBoardHandler.getMibOperations());
        target.setObjectID(oidString[0]);
        String[] stringArray = comms;
        int n = comms.length;
        int n2 = 0;
        while (n2 < n) {
            String comm = stringArray[n2];
            target.setCommunity(comm);
            String result = target.snmpGet();
            if (result != null) {
                this.getBoard().setSnmpCommunity(comm);
                this.getBoard().setActive();
            }
            ++n2;
        }
    }

    @Override
    public void run() {
        SnmpBSTarget target = null;
        String res = null;
        while (!this.isStoped()) {
            int row = BSFinder.getFinder().getIndexOfBoard(this.getBoard());
            if (row < 0) break;
            target = new SnmpBSTarget(this.getBoard());
            target.setMibOperations(SnmpBoardHandler.getMibOperations());
            target.setObjectID(oidString[0]);
            res = target.snmpGet();
            this.setIndicators(res, row, 0);
            target.setObjectID(oidString[1]);
            res = target.snmpGet();
            this.setIndicators(res, row, 1);
            target.setObjectID(oidString[2]);
            res = target.snmpGet();
            this.setIndicators(res, row, 2);
            BSFinder.getFinder().setBoardState(this.getBoard().isActive(), row);
            try {
                do {
                    Thread.sleep(2000L);
                } while (this.bPausedThread);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void setIndicators(String result, int row, int i) {
        if (result != null) {
            block0 : switch (i) {
                case 0: 
                case 1: {
                    int iResult = Integer.parseInt(result);
                    switch (iResult) {
                        case 0: {
                            BSFinder.getInstance().setStateLED(row, 5 + i, Constants.StateLED.off);
                            break block0;
                        }
                        case 1: {
                            BSFinder.getInstance().setStateLED(row, 5 + i, Constants.StateLED.on);
                        }
                    }
                    break;
                }
                case 2: {
                    float fResult = Float.parseFloat(result);
                    BSFinder.getInstance().getTable().setValueAt(Float.valueOf(fResult / 10.0f), row, 7);
                }
            }
        } else {
            switch (i) {
                case 0: 
                case 1: {
                    BSFinder.getInstance().setStateLED(row, 5 + i, Constants.StateLED.none);
                    break;
                }
                case 2: {
                    BSFinder.getInstance().getTable().getModel().setValueAt("-", row, 7);
                }
            }
        }
    }

    public void stop() {
        this.bStopThread = true;
    }

    public boolean isStoped() {
        return this.bStopThread;
    }

    public void pause() {
        this.bPausedThread = true;
    }

    public void resume() {
        this.bPausedThread = false;
    }
}

