/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.thread;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.utils.Constants;
import com.brennenstuhl.workers.AbstractBsHttpHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.http.HttpHost;

public class HttpBoardHandler
extends AbstractBsHttpHandler
implements Runnable {
    private volatile boolean bStopThread = false;
    private volatile boolean bPausedThread = false;

    public HttpBoardHandler(Board board) {
        super(board);
        this.url = this.getBoard().getIpAddr().getHostAddress();
        this.httpHost = new HttpHost(this.url, 80, "http");
    }

    public void clearHttpContext() {
        this.httpContext = null;
    }

    @Override
    public void run() {
        String res = null;
        while (!this.isStopped()) {
            CharBuffer cBuffer;
            int cBufferLen;
            ByteBuffer bBuffer;
            int row = BSFinder.getFinder().getIndexOfBoard(this.getBoard());
            if (row < 0) break;
            BSFinder.getFinder().setBoardState(this.getBoard().isActive(), row);
            int reqOffset = this.getRequestOffset();
            if (this.getBoard().isActive()) {
                bBuffer = this.sendHttpGet(reqOffset + 0, 0, 0);
                cBufferLen = bBuffer.position();
                bBuffer.rewind();
                cBuffer = Charset.forName("ISO-8859-1").decode(bBuffer);
                res = cBuffer.toString().substring(0, cBufferLen);
            } else {
                res = "";
            }
            this.setIndicators(res, row, 0);
            if (this.getBoard().isActive()) {
                bBuffer = this.sendHttpGet(reqOffset + 1, 0, 0);
                cBufferLen = bBuffer.position();
                bBuffer.rewind();
                cBuffer = Charset.forName("ISO-8859-1").decode(bBuffer);
                res = cBuffer.toString().substring(0, cBufferLen);
            } else {
                res = "";
            }
            this.setIndicators(res, row, 1);
            if (this.getBoard().isActive()) {
                bBuffer = this.sendHttpGet(reqOffset + 10, 0, 0);
                cBufferLen = bBuffer.position();
                bBuffer.rewind();
                cBuffer = Charset.forName("ISO-8859-1").decode(bBuffer);
                res = cBuffer.toString().substring(0, cBufferLen);
            } else {
                res = "";
            }
            this.setIndicators(res, row, 10);
            try {
                do {
                    Thread.sleep(2000L);
                } while (this.bPausedThread);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void toggleRelay(int column) {
        int reqOffset = this.getRequestOffset();
        switch (column) {
            case 5: {
                this.sendHttpGet(reqOffset + 20, 0, 0);
                break;
            }
            case 6: {
                this.sendHttpGet(reqOffset + 21, 0, 0);
            }
        }
    }

    int getRequestOffset() {
        int reqOffset = 300;
        if (this.getBoard().getBoardId() == 40 || this.getBoard().getBoardId() == 768) {
            reqOffset += 100;
        }
        return reqOffset;
    }

    private void setIndicators(String indState, int row, int reqType) {
        block21: {
            block19: {
                Constants.StateLED ledState;
                if (indState == null) break block19;
                switch (indState) {
                    case "on": {
                        ledState = Constants.StateLED.on;
                        break;
                    }
                    case "off": {
                        ledState = Constants.StateLED.off;
                        break;
                    }
                    default: {
                        ledState = Constants.StateLED.none;
                    }
                }
                switch (reqType) {
                    case 0: 
                    case 1: {
                        int tableColumn = reqType == 0 ? 5 : 6;
                        BSFinder.getInstance().setStateLED(row, tableColumn, ledState);
                        break;
                    }
                    case 10: {
                        String[] tokens;
                        String power = indState.length() > 0 ? ((tokens = indState.split("[|]")).length > 1 ? tokens[1] : "0") : "-";
                        BSFinder.getInstance().setPowerValue(row, power);
                    }
                }
                break block21;
            }
            switch (reqType) {
                case 0: {
                    BSFinder.getInstance().setStateLED(row, 5, Constants.StateLED.none);
                    break;
                }
                case 1: {
                    BSFinder.getInstance().setStateLED(row, 6, Constants.StateLED.none);
                    break;
                }
                case 10: {
                    BSFinder.getInstance().getTable().getModel().setValueAt("-", row, 7);
                }
            }
        }
    }

    public void stop() {
        this.bStopThread = true;
    }

    public boolean isStopped() {
        return this.bStopThread;
    }

    public void pause() {
        this.bPausedThread = true;
    }

    public void resume() {
        this.bPausedThread = false;
    }
}

