/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.thread;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.gui.renderer.BoardTableCellRenderer;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.unit.LocatorData;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FinderThread
extends Thread {
    private static final byte TAG_CMD = -1;
    private static final byte TAG_STATUS = -2;
    private static final byte CMD_DISCOVER_TARGET = 2;
    private static final byte CMD_LOCATE_TARGET_ON = 3;
    private static final byte CMD_LOCATE_TARGET_OFF = 4;
    private static final byte CMD_CONFIG_TARGET = 5;
    private static final byte LEN_DISCOVER_LM3S = 94;
    private static final byte LEN_DISCOVER_TM4C = 97;
    private static final int LOCATOR_PORT = 23;
    private static volatile FinderThread singletonInstance = new FinderThread();
    private volatile BSFinder guiObject = null;
    private final Semaphore sRefresh = new Semaphore(1, true);
    private volatile List<Board> boardList = new ArrayList<Board>();
    private DatagramSocket socket = null;
    private JTable table = null;
    private BoardTableCellRenderer renderer = null;

    private FinderThread() {
        try {
            this.socket = new DatagramSocket(23);
            this.socket.setBroadcast(true);
        }
        catch (SocketException e) {
            BSFinder.log(2, "Finder: exception: " + e.getMessage());
        }
        this.sRefresh.drainPermits();
        this.start();
    }

    private void sendBroadcast(InetAddress broadcastAddress, byte[] pcBuffer) {
        if (broadcastAddress != null) {
            try {
                DatagramPacket sendPacket = new DatagramPacket(pcBuffer, pcBuffer.length, broadcastAddress, 23);
                this.socket.send(sendPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendDiscovers(InetAddress broadcastAddress) throws SocketException {
        byte[] pcBuffer;
        pcBuffer = new byte[]{-1, 4, 2, (byte)(-(pcBuffer[0] + pcBuffer[1] + pcBuffer[2]))};
        this.sendBroadcast(broadcastAddress, pcBuffer);
    }

    public void clearBoardList() {
        this.boardList.clear();
        DefaultTableModel tableModel = (DefaultTableModel)this.guiObject.getTable().getModel();
        tableModel.setRowCount(0);
        BSFinder.clearPrefsNode("boards");
    }

    public void persistBoards() {
        for (Board board : this.boardList) {
            String node = "boards/board_" + board.getMacAsString().replace(":", "");
            BSFinder.setPrefsNode(node);
            BSFinder.prefs.put("ip_addr", board.getIpAddr().getHostAddress());
            BSFinder.prefs.put("netmask", board.getIpNetmask().getHostAddress());
            BSFinder.prefs.put("gateway", board.getIpGateway().getHostAddress());
            BSFinder.prefs.putInt("http_port", board.getHttpPort());
            BSFinder.prefs.putInt("board_type", board.getBoardType());
            BSFinder.prefs.putInt("board_id", board.getBoardId());
            BSFinder.prefs.putInt("board_features", board.getBoardFeatures());
            BSFinder.prefs.putByteArray("mac", board.getMac());
            BSFinder.prefs.putLong("version", board.getVersion());
            BSFinder.prefs.put("title", board.getAppTitleAsString());
            BSFinder.prefs.put("snmp_community", board.getSnmpCommunity());
            BSFinder.prefs.put("username", board.getUsername());
            BSFinder.prefs.put("password", board.getPassword());
        }
        BSFinder.setPrefsNode(null);
    }

    public void loadBoards() throws BackingStoreException, UnknownHostException {
        String[] arKeys;
        Board board = null;
        BSFinder.setPrefsNode("boards");
        String[] stringArray = arKeys = BSFinder.prefs.childrenNames();
        int n = arKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String node = "boards/" + s;
            BSFinder.setPrefsNode(node);
            board = new Board();
            board.setIpAddr(InetAddress.getByName(BSFinder.prefs.get("ip_addr", "0.0.0.0")));
            board.setIpNetmask(InetAddress.getByName(BSFinder.prefs.get("netmask", "0.0.0.0")));
            board.setIpGateway(InetAddress.getByName(BSFinder.prefs.get("gateway", "0.0.0.0")));
            board.setHttpPort((short)BSFinder.prefs.getInt("http_port", 80));
            board.setBoardType((byte)BSFinder.prefs.getInt("board_type", 0));
            board.setBoardId((short)BSFinder.prefs.getInt("board_id", 0));
            board.setBoardFeatures((short)BSFinder.prefs.getInt("board_features", 0));
            board.setMac(BSFinder.prefs.getByteArray("mac", new byte[6]));
            board.setVersion(BSFinder.prefs.getLong("version", 0L));
            board.setAppTitleAsString(BSFinder.prefs.get("title", ""));
            board.setSnmpCommunity(BSFinder.prefs.get("snmp_community", "public"));
            board.setUsername(BSFinder.prefs.get("username", "admin"));
            board.setPassword(BSFinder.prefs.get("password", "admin"));
            this.addToBoardList(board);
            ++n2;
        }
    }

    public void setBoardState(boolean isActive, int iIndex) {
        this.renderer.setLineActive(isActive, iIndex);
        this.table.validate();
        this.table.repaint();
    }

    private void addBoard(InterfaceAddress intfLocal, LocatorData l) {
        Board board = new Board();
        board.setIpAddr(l.getIpAddress());
        board.setIpNetmask(l.getIpNetmask());
        board.setIpGateway(l.getIpGateway());
        board.setHttpPort(l.getHttpPort());
        board.setIntfLocal(intfLocal);
        board.setBoardType(l.getBoardType());
        board.setBoardId(l.getBoardId());
        board.setBoardFeatures(l.getBoardFeatures());
        board.setMac(l.getMac());
        board.setVersion(l.getVersion());
        if (l.getIpAddress().getHostAddress().equals("0.0.0.0")) {
            board.setAppTitle(BSFinder.resourceManager.getString("Finder.addBoard.Configure").getBytes());
        } else {
            board.setAppTitle(l.getAppTitle());
        }
        board.setActive();
        board.setUsername(BSFinder.prefs.get("username", "admin"));
        board.setPassword(BSFinder.prefs.get("password", "admin"));
        this.addToBoardList(board);
    }

    private void addToBoardList(Board board) {
        ListIterator<Board> itBoard = this.boardList.listIterator();
        boolean bAlreadyPresent = false;
        int iIndex = -1;
        Board boardL = null;
        while (itBoard.hasNext()) {
            ++iIndex;
            boardL = itBoard.next();
            if (!boardL.equals(board)) continue;
            bAlreadyPresent = true;
            break;
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        if (bAlreadyPresent) {
            tableModel.setValueAt(board.getIpAddr().getHostAddress(), iIndex, 1);
            tableModel.setValueAt(board.getVersionAsString(), iIndex, 3);
            tableModel.setValueAt(board.getAppTitleAsString(), iIndex, 4);
            if (boardL.updateBoard(board)) {
                boardL.snmpExplore();
            }
        } else {
            this.boardList.add(board);
            board.snmpExplore();
            iIndex = this.boardList.size() - 1;
            Object[] objectArray = new Object[5];
            objectArray[1] = board.getIpAddr().getHostAddress();
            objectArray[2] = board.getMacAsString();
            objectArray[3] = board.getVersionAsString();
            objectArray[4] = board.getAppTitleAsString();
            tableModel.addRow(objectArray);
        }
    }

    private void readResponses(InterfaceAddress intfLocal) throws SocketException, IOException {
        byte[] pcBuffer = null;
        int iTimeout = this.boardList.size() == 0 ? 5000 : 2000;
        this.socket.setSoTimeout(iTimeout);
        while (true) {
            pcBuffer = new byte[256];
            DatagramPacket receivePacket = new DatagramPacket(pcBuffer, pcBuffer.length);
            try {
                this.socket.receive(receivePacket);
            }
            catch (SocketTimeoutException e) {
                break;
            }
            if (pcBuffer[0] != -2 || pcBuffer[2] != 2 || pcBuffer[1] != 94 && pcBuffer[1] != 97) continue;
            int iMax = 0;
            int iLoop = 0;
            while (iLoop < pcBuffer[1]) {
                iMax -= pcBuffer[iLoop] & 0xFF;
                ++iLoop;
            }
            if ((iMax & 0xFF) != 0) continue;
            LocatorData l = new LocatorData(pcBuffer);
            this.addBoard(intfLocal, l);
        }
    }

    public void rescanNetwork() {
        this.sRefresh.release();
    }

    void setBoardsInactive() {
        Board boardL = null;
        ListIterator<Board> itBoard = this.boardList.listIterator();
        while (itBoard.hasNext()) {
            boardL = itBoard.next();
            boardL.setInactive();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            this.setBoardsInactive();
            try {
                this.sRefresh.tryAcquire(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException var1_2) {
                // empty catch block
            }
            BSFinder.log(2, "Discover network");
            if (this.socket == null) {
                JOptionPane.showMessageDialog(null, BSFinder.resourceManager.getString("bsFinder.Finder.SockError"), BSFinder.resourceManager.getString("bsFinder.Finder.Socket"), 2);
                return;
            }
            broadcast = null;
            try {
                broadcast = InetAddress.getByName("255.255.255.255");
                this.sendDiscovers(broadcast);
                this.readResponses(null);
            }
            catch (IOException e2) {
                System.err.println("Exception on network interface: broadcast to 255.255.255.255");
            }
            try {
                netIntfs = NetworkInterface.getNetworkInterfaces();
                if (true) ** GOTO lbl41
            }
            catch (SocketException e) {
                System.err.println("Cannot get network interface list");
                return;
            }
            do {
                netIntf = netIntfs.nextElement();
                try {
                    if (netIntf.isLoopback() || !netIntf.isUp()) continue;
                    for (InterfaceAddress interfaceAddress : netIntf.getInterfaceAddresses()) {
                        broadcast = interfaceAddress.getBroadcast();
                        if (broadcast == null) continue;
                        BSFinder.log(2, "Send DISCOVER to: " + broadcast.getHostAddress() + "; Intf: " + netIntf.getDisplayName());
                        this.sendDiscovers(broadcast);
                        this.readResponses(interfaceAddress);
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception on interface " + netIntf.getDisplayName() + ": broadcast to " + broadcast.getHostAddress());
                }
lbl41:
                // 4 sources

            } while (netIntfs.hasMoreElements());
        }
    }

    public static FinderThread getInstance() {
        return singletonInstance;
    }

    public void setGuiObject(BSFinder object) {
        this.guiObject = object;
        this.table = this.guiObject.getTable();
        this.renderer = (BoardTableCellRenderer)this.table.getDefaultRenderer(String.class);
    }

    public Board getBoard(int index) {
        if (index >= 0) {
            return this.boardList.get(index);
        }
        return null;
    }

    public int getIndexOfBoard(Board board) {
        return this.boardList.indexOf(board);
    }

    public List<Board> getBoardList(int[] index) {
        ArrayList<Board> boardLst = new ArrayList<Board>();
        int i = 0;
        while (i < index.length) {
            Board board = this.getBoard(index[i]);
            if (board != null) {
                boardLst.add(board);
            }
            ++i;
        }
        return boardLst;
    }

    public List<Board> getBoardList() {
        return this.boardList;
    }

    public void sendLocate(int index, String ipAddress, Boolean bLocateOnOff) {
        InetAddress ip;
        ByteArrayOutputStream bObj = new ByteArrayOutputStream();
        bObj.reset();
        bObj.write(-1);
        bObj.write(8);
        bObj.write(bLocateOnOff != false ? 3 : 4);
        try {
            ip = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            BSFinder.log(1, "sendLocate: cannot create ip address " + ipAddress);
            return;
        }
        bObj.write(ip.getAddress(), 0, 4);
        int checksum = 0;
        int i = 0;
        while (i < bObj.size()) {
            checksum -= bObj.toByteArray()[i] & 0xFF;
            ++i;
        }
        bObj.write((byte)checksum);
        Board board = this.getBoard(index);
        this.sendBroadcast(board.getIntfLocal().getBroadcast(), bObj.toByteArray());
        Toolkit.getDefaultToolkit().beep();
    }

    public void sendConfig(Board board, InetAddress ip, InetAddress netmask, InetAddress gateway, short usPort) {
        ByteArrayOutputStream bObj = new ByteArrayOutputStream();
        bObj.reset();
        bObj.write(-1);
        bObj.write(24);
        bObj.write(5);
        bObj.write(board.getMac(), 0, board.getMac().length);
        bObj.write(ip.getAddress(), 0, 4);
        bObj.write(netmask.getAddress(), 0, 4);
        bObj.write(gateway.getAddress(), 0, 4);
        bObj.write(new byte[]{(byte)usPort, (byte)(usPort >> 8)}, 0, 2);
        int checksum = 0;
        int i = 0;
        while (i < bObj.size()) {
            checksum -= bObj.toByteArray()[i] & 0xFF;
            ++i;
        }
        bObj.write((byte)checksum);
        checksum = 0;
        i = 0;
        while (i < 24) {
            checksum += bObj.toByteArray()[i] & 0xFF;
            ++i;
        }
        if (board.getIpAddr().getHostAddress().equals("0.0.0.0") || board.getIntfLocal() == null) {
            InetAddress ipBC = null;
            try {
                ipBC = InetAddress.getByName("255.255.255.255");
                this.sendBroadcast(ipBC, bObj.toByteArray());
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            this.sendBroadcast(board.getIntfLocal().getBroadcast(), bObj.toByteArray());
        }
        Toolkit.getDefaultToolkit().beep();
    }
}

