/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.gui.History24hRendererFirstReadyChecker;
import com.brennenstuhl.thread.HistoryRendererThread;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.utils.Constants;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ChartWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private Board board;
    private JTextField textField;
    private JPanel _24hChartPanel;
    private JPanel _10sChartPanel;
    private JLabel lbl24h;
    private JLabel lbl10s;
    private HistoryRendererThread history24hDataRenderer;
    private HistoryRendererThread history10sDataRenderer;

    public ChartWindow(Board board) throws PatternSyntaxException {
        Image icon = new ImageIcon(BSFinder.class.getResource("/images/logo_small.gif")).getImage();
        this.setIconImage(icon);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                ChartWindow window = (ChartWindow)evt.getSource();
                HistoryRendererThread ahr = window.getDataRenderer(true);
                if (ahr != null) {
                    ahr.stop();
                }
                if ((ahr = window.getDataRenderer(false)) != null) {
                    ahr.stop();
                }
                BSFinder.saveWindowPos("window/history", window);
                Board board = window.getBoard();
                board.setHistoryActive(false);
                board.getHttpWorker().resume();
            }
        });
        this.board = board;
        this.board.setHistoryActive(true);
        this.board.getHttpWorker().pause();
        this.history24hDataRenderer = new HistoryRendererThread(Constants.ChartMode.H24, this);
        this.setTitle(BSFinder.resourceManager.getString("ChartWindow.this.title"));
        BSFinder.setWindowPos("window/history", this, 100, 100, 900, 600);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        JPanel grpDevice = new JPanel();
        grpDevice.setFocusTraversalKeysEnabled(false);
        grpDevice.setFocusable(false);
        grpDevice.setBorder(new TitledBorder(null, BSFinder.resourceManager.getString("TagDevice"), 4, 2, null, null));
        JLabel lblLogo = new JLabel();
        lblLogo.setFocusable(false);
        lblLogo.setPreferredSize(new Dimension(150, 90));
        lblLogo.setFocusTraversalKeysEnabled(false);
        lblLogo.setIcon(new ImageIcon(ChartWindow.class.getResource("/images/logo_small.gif")));
        this.textField = new JTextField();
        this.textField.setEditable(false);
        this.textField.setColumns(10);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.lbl24h = new JLabel();
        this.lbl24h.setHorizontalAlignment(0);
        this.lbl24h.setVerticalAlignment(0);
        this.lbl24h.setPreferredSize(new Dimension(100, 100));
        this.lbl24h.setFocusable(false);
        this.lbl24h.setFocusTraversalKeysEnabled(false);
        this.lbl24h.setIcon(new ImageIcon(ChartWindow.class.getResource("/images/ajax_loader.gif")));
        this._24hChartPanel = new JPanel();
        tabbedPane.addTab(BSFinder.resourceManager.getString("24h.text"), null, this._24hChartPanel, null);
        this._24hChartPanel.setLayout(new BorderLayout(0, 0));
        this._24hChartPanel.add(this.lbl24h);
        this.lbl10s = new JLabel();
        this.lbl10s.setHorizontalAlignment(0);
        this.lbl10s.setVerticalAlignment(0);
        this.lbl10s.setPreferredSize(new Dimension(100, 100));
        this.lbl10s.setFocusable(false);
        this.lbl10s.setFocusTraversalKeysEnabled(false);
        this.lbl10s.setIcon(new ImageIcon(ChartWindow.class.getResource("/images/ajax_loader.gif")));
        this._10sChartPanel = new JPanel();
        tabbedPane.addTab(BSFinder.resourceManager.getString("10s.text"), null, this._10sChartPanel, null);
        this._10sChartPanel.setLayout(new BorderLayout(0, 0));
        this._10sChartPanel.add(this.lbl10s);
        GroupLayout gl_contentPane = new GroupLayout(this.contentPane);
        gl_contentPane.setHorizontalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGap(10).addComponent(lblLogo, -2, -1, -2).addGap(12).addComponent(grpDevice, -1, 437, Short.MAX_VALUE).addGap(5)).addGroup(gl_contentPane.createSequentialGroup().addGap(5).addComponent(tabbedPane, -1, 604, Short.MAX_VALUE).addGap(5)));
        gl_contentPane.setVerticalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGap(10).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lblLogo, -2, -1, -2).addGroup(gl_contentPane.createSequentialGroup().addGap(17).addComponent(grpDevice, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE))).addGap(6).addComponent(tabbedPane, -1, 321, Short.MAX_VALUE).addGap(5)));
        GroupLayout gl_grpDevice = new GroupLayout(grpDevice);
        gl_grpDevice.setHorizontalGroup(gl_grpDevice.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_grpDevice.createSequentialGroup().addGap(15).addComponent(this.textField, -1, 395, Short.MAX_VALUE).addGap(15)));
        gl_grpDevice.setVerticalGroup(gl_grpDevice.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_grpDevice.createSequentialGroup().addGap(4).addComponent(this.textField, -2, -1, -2)));
        grpDevice.setLayout(gl_grpDevice);
        this.contentPane.setLayout(gl_contentPane);
        this.textField.setText(board.toString());
        new Thread(this.history24hDataRenderer).start();
        new Thread(new History24hRendererFirstReadyChecker(this)).start();
        this.setVisible(true);
    }

    public Board getBoard() {
        return this.board;
    }

    public HistoryRendererThread getDataRenderer(boolean is24h) {
        if (is24h) {
            return this.history24hDataRenderer;
        }
        return this.history10sDataRenderer;
    }

    public void setDataRenderer(boolean is24h, HistoryRendererThread dataRenderer) {
        if (is24h) {
            this.history24hDataRenderer = dataRenderer;
        } else {
            this.history10sDataRenderer = dataRenderer;
        }
    }

    public JPanel getChartPanel(boolean is24h) {
        if (is24h) {
            return this._24hChartPanel;
        }
        return this._10sChartPanel;
    }

    public void hideLabel(boolean is24h) {
        if (is24h) {
            this.lbl24h.setVisible(false);
        } else {
            this.lbl10s.setVisible(false);
        }
    }

    public void showLoader(boolean is24h) {
        if (is24h) {
            this.lbl24h.setText(null);
            this.lbl24h.setIcon(new ImageIcon(ChartWindow.class.getResource("/images/ajax_loader.gif")));
            this.lbl24h.setVisible(true);
        } else {
            this.lbl10s.setText(null);
            this.lbl10s.setIcon(new ImageIcon(ChartWindow.class.getResource("/images/ajax_loader.gif")));
            this.lbl10s.setVisible(true);
        }
    }

    public void showNoData(boolean is24h) {
        if (is24h) {
            this.lbl24h.setText(BSFinder.resourceManager.getString("no_data"));
            this.lbl24h.setIcon(null);
            this.lbl24h.setVisible(true);
        } else {
            this.lbl10s.setText(BSFinder.resourceManager.getString("no_data"));
            this.lbl10s.setIcon(null);
            this.lbl10s.setVisible(true);
        }
    }
}

