/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui;

import com.brennenstuhl.gui.ChartWindow;
import com.brennenstuhl.gui.DownloadMultiple;
import com.brennenstuhl.gui.IpSetup;
import com.brennenstuhl.gui.UserSetup;
import com.brennenstuhl.gui.renderer.BoardTableCellRenderer;
import com.brennenstuhl.gui.renderer.InfoCellRenderer;
import com.brennenstuhl.thread.FinderThread;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.utils.Constants;
import com.brennenstuhl.utils.ResourceManager;
import com.brennenstuhl.workers.BSFinderWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BSFinder {
    public static ResourceManager resourceManager = ResourceManager.INSTANCE;
    public static Preferences prefs = Preferences.userRoot();
    private static ImageIcon[] arIcon = new ImageIcon[2];
    private static BSFinderWorker objWorker;
    private static Boolean bForceImageUpdate;
    private static Boolean bLogging;
    private static int logLevel;
    private static FinderThread objFinder;
    private static BSFinder window;
    private JFrame frmBsfinder;
    private JTable table;
    private JCheckBoxMenuItem mntmLocate = null;
    private JMenuItem mntmBrowser = null;
    private JMenuItem mntmSwDownload = null;
    private JMenuItem mntmConfig = null;
    private JMenuItem mntmSnmpConfig = null;
    private JMenuItem mntmHistory = null;
    private DefaultTableModel defaultModel;

    static {
        bForceImageUpdate = false;
        bLogging = false;
        logLevel = 1;
        window = null;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("FORCE")) {
                    bForceImageUpdate = true;
                }
                if (args[i].equals("LOG1")) {
                    bLogging = true;
                    logLevel = 1;
                }
                if (args[i].equals("LOG2")) {
                    bLogging = true;
                    logLevel = 2;
                }
                ++i;
            }
        }
        BSFinder.setPrefsNode("");
        EventQueue.invokeLater(() -> {
            try {
                window = new BSFinder();
                BSFinder.window.frmBsfinder.setVisible(true);
                objFinder = FinderThread.getInstance();
                objFinder.setGuiObject(window);
                objWorker = BSFinderWorker.getInstance();
                objWorker.setGuiObject(window);
                objWorker.setFinderObject(objFinder);
                try {
                    objFinder.loadBoards();
                }
                catch (UnknownHostException | BackingStoreException e1) {
                    e1.printStackTrace();
                }
                objFinder.rescanNetwork();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public BSFinder() {
        this.initialize();
    }

    public static void log(int level, String s) {
        if (bLogging.booleanValue() && level >= logLevel) {
            System.out.println(s);
        }
    }

    public static BSFinder getInstance() {
        return window;
    }

    public static FinderThread getFinder() {
        return objFinder;
    }

    private void initialize() {
        URL imageURLgn = BSFinder.class.getResource("/images/gled.png");
        URL imageURLgr = BSFinder.class.getResource("/images/grled.png");
        if (imageURLgn != null && imageURLgr != null) {
            try {
                BSFinder.arIcon[0] = new ImageIcon(imageURLgr);
                BSFinder.arIcon[1] = new ImageIcon(imageURLgn);
            }
            catch (Exception e) {
                BSFinder.log(1, e.getLocalizedMessage());
            }
        } else {
            BSFinder.log(1, "Could not get image resources: Null-pointer!");
        }
        this.frmBsfinder = new JFrame();
        Image icon = new ImageIcon(BSFinder.class.getResource("/images/logo_small.gif")).getImage();
        this.frmBsfinder.setIconImage(icon);
        this.frmBsfinder.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    BSFinder.this.saveColumnWidth();
                    BSFinder.saveWindowPos("window", BSFinder.this.frmBsfinder);
                    BSFinder.this.saveColumnOrder();
                    objFinder.persistBoards();
                    prefs.flush();
                }
                catch (BackingStoreException e1) {
                    System.err.println("Could not save Preferences");
                }
            }
        });
        this.frmBsfinder.setTitle(resourceManager.getString("bsFinder.frmBsfinder.title"));
        BSFinder.setWindowPos("window", this.frmBsfinder, 100, 100, 640, 480);
        this.frmBsfinder.setDefaultCloseOperation(3);
        SpringLayout springLayout = new SpringLayout();
        this.frmBsfinder.getContentPane().setLayout(springLayout);
        JLabel lblLabelLogo = new JLabel();
        lblLabelLogo.setPreferredSize(new Dimension(150, 90));
        lblLabelLogo.setIcon(new ImageIcon(BSFinder.class.getResource("/images/logo.gif")));
        springLayout.putConstraint("North", (Component)lblLabelLogo, 5, "North", (Component)this.frmBsfinder.getContentPane());
        springLayout.putConstraint("West", (Component)lblLabelLogo, 5, "West", (Component)this.frmBsfinder.getContentPane());
        this.frmBsfinder.getContentPane().add(lblLabelLogo);
        JLabel lblPremiumweblineSteckdosenleisten = new JLabel(resourceManager.getString("bsFinder.lblPremiumweblineSteckdosenleisten.text"));
        springLayout.putConstraint("North", (Component)lblPremiumweblineSteckdosenleisten, 15, "North", (Component)this.frmBsfinder.getContentPane());
        lblPremiumweblineSteckdosenleisten.setHorizontalAlignment(0);
        lblPremiumweblineSteckdosenleisten.setFont(new Font("Liberation Sans", 1, 20));
        springLayout.putConstraint("West", (Component)lblPremiumweblineSteckdosenleisten, 10, "East", (Component)lblLabelLogo);
        springLayout.putConstraint("East", (Component)lblPremiumweblineSteckdosenleisten, 10, "East", (Component)this.frmBsfinder.getContentPane());
        this.frmBsfinder.getContentPane().add(lblPremiumweblineSteckdosenleisten);
        JLabel lblVersion = new JLabel(resourceManager.getString("bsFinder.lblVersion.text"));
        springLayout.putConstraint("North", (Component)lblVersion, 15, "South", (Component)lblPremiumweblineSteckdosenleisten);
        lblVersion.setHorizontalAlignment(0);
        lblVersion.setFont(new Font("Liberation Sans", 1, 14));
        springLayout.putConstraint("West", (Component)lblVersion, 10, "East", (Component)lblLabelLogo);
        springLayout.putConstraint("East", (Component)lblVersion, 10, "East", (Component)this.frmBsfinder.getContentPane());
        this.frmBsfinder.getContentPane().add(lblVersion);
        JButton btnErase = new JButton(resourceManager.getString("btnErase.text"));
        springLayout.putConstraint("West", (Component)btnErase, 10, "West", (Component)this.frmBsfinder.getContentPane());
        btnErase.addActionListener(event -> {
            objWorker.clearList();
            this.mntmLocate.setSelected(false);
        });
        this.frmBsfinder.getContentPane().add(btnErase);
        JScrollPane scrollPane = new JScrollPane();
        springLayout.putConstraint("North", (Component)btnErase, 5, "South", (Component)scrollPane);
        springLayout.putConstraint("North", (Component)scrollPane, 10, "South", (Component)lblLabelLogo);
        springLayout.putConstraint("West", (Component)scrollPane, 5, "West", (Component)this.frmBsfinder.getContentPane());
        springLayout.putConstraint("South", (Component)scrollPane, -35, "South", (Component)this.frmBsfinder.getContentPane());
        springLayout.putConstraint("East", (Component)scrollPane, -5, "East", (Component)this.frmBsfinder.getContentPane());
        this.frmBsfinder.getContentPane().add(scrollPane);
        this.defaultModel = new DefaultTableModel(new Object[0][], new String[]{"L", resourceManager.getString("IP"), resourceManager.getString("MAC"), resourceManager.getString("bsFinder.tableModel.Version"), resourceManager.getString("DevName"), "R1", "R2", resourceManager.getString("bsFinder.tableModel.Power")}){
            private static final long serialVersionUID = 1L;
            Class[] columnTypes;
            boolean[] columnEditables;
            {
                this.columnTypes = new Class[]{ImageIcon.class, String.class, String.class, String.class, String.class, ImageIcon.class, ImageIcon.class, String.class};
                this.columnEditables = new boolean[8];
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.columnEditables[column];
            }
        };
        this.table = new JTable();
        this.table.setSelectionMode(2);
        this.table.setFillsViewportHeight(true);
        this.table.setModel(this.defaultModel);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(0).setMaxWidth(15);
        this.table.getColumnModel().getColumn(0).setMinWidth(15);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(5).setResizable(false);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(18);
        this.table.getColumnModel().getColumn(5).setMaxWidth(18);
        this.table.getColumnModel().getColumn(5).setMinWidth(18);
        this.table.getColumnModel().getColumn(6).setResizable(false);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(18);
        this.table.getColumnModel().getColumn(6).setMaxWidth(18);
        this.table.getColumnModel().getColumn(6).setMinWidth(18);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(60);
        this.table.setDefaultRenderer(String.class, new BoardTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new InfoCellRenderer());
        this.setColumnWidth();
        this.setColumnOrder();
        scrollPane.setViewportView(this.table);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BSFinder.this.mntmSwDownload.setEnabled(false);
                BSFinder.this.mntmLocate.setEnabled(false);
                BSFinder.this.mntmBrowser.setEnabled(false);
                BSFinder.this.mntmConfig.setEnabled(false);
                BSFinder.this.mntmHistory.setEnabled(false);
                if (BSFinder.this.table.getSelectedRow() >= 0) {
                    if (!objFinder.getBoard(BSFinder.this.table.getSelectedRow()).getIpAddr().getHostAddress().equals("0.0.0.0")) {
                        BSFinder.this.mntmSwDownload.setEnabled(!DownloadMultiple.isRunning());
                    }
                    if (BSFinder.this.table.getSelectedRowCount() == 1) {
                        if ((ImageIcon)BSFinder.this.table.getModel().getValueAt(BSFinder.this.table.getSelectedRow(), 0) == null) {
                            BSFinder.this.mntmLocate.setSelected(false);
                        } else {
                            BSFinder.this.mntmLocate.setSelected(true);
                        }
                        Board b = objFinder.getBoard(BSFinder.this.table.getSelectedRow());
                        if (!b.getIpAddr().getHostAddress().equals("0.0.0.0") && b.getVersion() != 0L) {
                            BSFinder.this.mntmLocate.setEnabled(true);
                            BSFinder.this.mntmBrowser.setEnabled(true);
                        }
                        BSFinder.this.mntmConfig.setEnabled(true);
                        if (b.isActive() && !b.isHistoryActive()) {
                            BSFinder.this.mntmHistory.setEnabled(true);
                        }
                    }
                }
            }
        });
        BSFinder.addPopup(this.table, popupMenu);
        this.mntmLocate = new JCheckBoxMenuItem(resourceManager.getString("bsFinder.mntmLocate.text"));
        this.mntmLocate.addActionListener(event -> objWorker.startLocateTimer((String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1), this.table.getSelectedRow(), ((JCheckBoxMenuItem)event.getSource()).getState()));
        popupMenu.add(this.mntmLocate);
        this.mntmBrowser = new JMenuItem(resourceManager.getString("bsFinder.mntmBrowser.text"));
        this.mntmBrowser.addActionListener(event -> objWorker.openBrowser(this.table.getSelectedRow()));
        popupMenu.add(this.mntmBrowser);
        this.mntmSwDownload = new JMenuItem(resourceManager.getString("bsFinder.mntmSwDownload.text"));
        this.mntmSwDownload.addActionListener(event -> DownloadMultiple.downloadDialog(this.frmBsfinder, objFinder.getBoardList(this.table.getSelectedRows())));
        popupMenu.add(this.mntmSwDownload);
        this.mntmConfig = new JMenuItem(resourceManager.getString("bsFinder.mntmConfig.text"));
        this.mntmConfig.addActionListener(event -> {
            if (this.table.getSelectedRow() >= 0) {
                IpSetup.configDialog(this.frmBsfinder, objFinder, objFinder.getBoard(this.table.getSelectedRow()));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        popupMenu.add(this.mntmConfig);
        this.mntmHistory = new JMenuItem(resourceManager.getString("bsFinder.mntmHistory.text"));
        this.mntmHistory.addActionListener(event -> {
            if (this.table.getSelectedRow() >= 0) {
                new ChartWindow(objFinder.getBoard(this.table.getSelectedRow()));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        popupMenu.add(this.mntmHistory);
        this.mntmSnmpConfig = new JMenuItem(resourceManager.getString("bsFinder.mntmSnmpConfig.text"));
        this.mntmSnmpConfig.addActionListener(event -> {
            if (this.table.getSelectedRow() >= 0) {
                UserSetup.configDialog(this.frmBsfinder, objFinder.getBoard(this.table.getSelectedRow()));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        popupMenu.add(this.mntmSnmpConfig);
        JButton btnSearch = new JButton(resourceManager.getString("btnSearch.text"));
        btnSearch.addActionListener(event -> objWorker.discoverNetwork());
        springLayout.putConstraint("North", (Component)btnSearch, 5, "South", (Component)scrollPane);
        springLayout.putConstraint("West", (Component)btnSearch, 15, "East", (Component)btnErase);
        this.frmBsfinder.getContentPane().add(btnSearch);
        JButton btnExit = new JButton(resourceManager.getString("btnExit.text"));
        btnExit.addActionListener(event -> {
            try {
                this.saveColumnWidth();
                BSFinder.saveWindowPos("window", this.frmBsfinder);
                this.saveColumnOrder();
                objFinder.persistBoards();
                prefs.flush();
            }
            catch (BackingStoreException e1) {
                System.err.println("Could not save Preferences");
            }
            System.exit(0);
        });
        springLayout.putConstraint("North", (Component)btnExit, 5, "South", (Component)scrollPane);
        springLayout.putConstraint("East", (Component)btnExit, -10, "East", (Component)this.frmBsfinder.getContentPane());
        this.frmBsfinder.getContentPane().add(btnExit);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setStateLED(int row, int column, Constants.StateLED state) {
        ImageIcon icon;
        switch (state) {
            case off: {
                icon = arIcon[0];
                break;
            }
            case on: {
                icon = arIcon[1];
                break;
            }
            default: {
                icon = null;
            }
        }
        if (this.table.getModel().getRowCount() > row) {
            this.table.getModel().setValueAt(icon, row, column);
        }
    }

    public void setPowerValue(int row, String power) {
        if (this.table.getModel().getRowCount() > row) {
            this.table.getModel().setValueAt(power, row, 7);
        }
    }

    public void rescanNetwork() {
        objFinder.rescanNetwork();
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                Point p = e.getPoint();
                int row = table.rowAtPoint(p);
                if (e.getButton() == 3) {
                    int[] num = table.getSelectedRows();
                    boolean b = false;
                    int[] nArray = num;
                    int n = num.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        if (i == row) {
                            b = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!b) {
                        table.clearSelection();
                        table.changeSelection(row, 0, true, false);
                    }
                    this.showMenu(e);
                } else if (e.getClickCount() == 2) {
                    int column = table.columnAtPoint(p);
                    if (column == 5 || column == 6) {
                        Object icon;
                        Board b = objFinder.getBoard(row);
                        if (b.isActive() && (icon = table.getModel().getValueAt(row, column)) != null) {
                            b.getHttpWorker().pause();
                            b.getHttpWorker().toggleRelay(column);
                            b.getHttpWorker().resume();
                        }
                    } else {
                        objWorker.openBrowser(row);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private void setColumnOrder() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        TableColumn[] column = new TableColumn[columnCount];
        BSFinder.setPrefsNode("table");
        int i = 0;
        while (i < column.length) {
            column[i] = columnModel.getColumn(i);
            ++i;
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        i = 0;
        while (i < column.length) {
            columnModel.addColumn(column[prefs.getInt("column" + i, i)]);
            ++i;
        }
        BSFinder.setPrefsNode(null);
    }

    private void saveColumnOrder() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        BSFinder.setPrefsNode("table");
        int i = 0;
        while (i < columnCount) {
            prefs.putInt("column" + i, columnModel.getColumn(i).getModelIndex());
            ++i;
        }
        BSFinder.setPrefsNode(null);
    }

    private void setColumnWidth() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        BSFinder.setPrefsNode("table");
        int i = 0;
        while (i < columnCount) {
            TableColumn column = columnModel.getColumn(i);
            int w = prefs.getInt("width" + i, column.getPreferredWidth());
            column.setPreferredWidth(w);
            ++i;
        }
        BSFinder.setPrefsNode(null);
    }

    private void saveColumnWidth() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        TableColumn[] column = new TableColumn[columnCount];
        BSFinder.setPrefsNode("table");
        int i = 0;
        while (i < column.length) {
            column[i] = columnModel.getColumn(i);
            ++i;
        }
        i = 0;
        while (i < column.length) {
            prefs.putInt("width" + i, column[i].getWidth());
            ++i;
        }
        BSFinder.setPrefsNode(null);
    }

    static void setWindowPos(String node, JFrame window, int wndPosX, int wndPosY, int wndSizeX, int wndSizeY) {
        BSFinder.setPrefsNode(node);
        wndPosX = prefs.getInt("pos_x", wndPosX);
        wndPosY = prefs.getInt("pos_y", wndPosY);
        wndSizeX = prefs.getInt("size_x", wndSizeX);
        wndSizeY = prefs.getInt("size_y", wndSizeY);
        window.setBounds(wndPosX, wndPosY, wndSizeX, wndSizeY);
        BSFinder.setPrefsNode(null);
    }

    static void saveWindowPos(String node, JFrame window) {
        BSFinder.setPrefsNode(node);
        if (window.getExtendedState() != 6) {
            prefs.putInt("pos_x", window.getX());
            prefs.putInt("pos_y", window.getY());
            prefs.putInt("size_x", window.getWidth());
            prefs.putInt("size_y", window.getHeight());
        }
        BSFinder.setPrefsNode(null);
    }

    public static Boolean getbForceImageUpdate() {
        return bForceImageUpdate;
    }

    public static void setPrefsNode(String node) {
        if (node != null && !node.isEmpty()) {
            prefs = prefs.node("/bs_finder/" + node);
        }
    }

    public static void clearPrefsNode(String node) {
        if (node != null && !node.isEmpty()) {
            prefs = prefs.node("/bs_finder/" + node);
            try {
                prefs.removeNode();
                prefs.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        prefs = Preferences.userRoot();
        BSFinder.setPrefsNode(null);
    }
}

