/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.workers;

import com.brennenstuhl.exception.WrongBinaryException;
import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.gui.DownloadMultiple;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.unit.BootPPackage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;

public class MBootServer {
    private static final String serverName = "brennenstuhl";
    private static final int MPACKET_HEADER_LEN = 6;
    private static final int MPACKET_MAC_REP = 4;
    private static final int MPACKET_MAC_LEN = 6;
    private static final int MPACKET_LEN = 30;
    private static final int MPACKET_MARKER = 170;
    private static final long selTimeout = 10000L;
    private static final int MPACKET_PORT = 9;
    private static final int BOOTP_SERVER_PORT = 67;
    private static final int BOOT_TARGET_PORT = 68;
    private static final byte BOOTP_REQUEST = 1;
    private static final byte BOOTP_REPLY = 2;
    private static final int TFTP_PORT = 69;
    private static final short TFTP_RRQ = 1;
    private static final short TFTP_DATA = 3;
    private static final short TFTP_ACK = 4;
    private static final short TFTP_ERROR = 5;
    private static final int HWTYPE_POS_LM3 = 248;
    private static final int HWTYPE_POS_TM4 = 528;
    private static final int HWVERSION_POS_LM3 = 252;
    private static final int HWVERSION_POS_TM4 = 532;
    private DatagramSocket socketUpdate = null;
    private boolean bBootPPacketSeen = false;
    private DatagramChannel channelBootP = DatagramChannel.open();
    private DatagramChannel channelTftp = DatagramChannel.open();
    private DatagramChannel channelTftpData = DatagramChannel.open();
    private SelectionKey keyBootP = null;
    private SelectionKey keyTftp = null;
    private SelectionKey keyTftpData = null;
    private Selector selector = null;
    private ByteBuffer readBuffer = ByteBuffer.allocate(1024);
    private ByteBuffer writeBuffer = ByteBuffer.allocate(700);
    private byte[] imageBuffer = null;
    private byte[] macAddress = null;
    private InetAddress ipTarget = null;
    private InterfaceAddress intfLocal = null;
    private DownloadMultiple dlgDownload = null;
    private int remotePort = 0;
    private int tableIndex = -1;
    private int blockNumber = 0;
    private int toCount = 0;
    private boolean bAbortBOOTP = false;

    public MBootServer() throws IOException {
        this.socketUpdate = new DatagramSocket();
        this.selector = Selector.open();
        this.keyBootP = this.initSelector(this.channelBootP, 67);
        this.keyTftp = this.initSelector(this.channelTftp, 69);
    }

    public void abortBootPUpdate() {
        this.bAbortBOOTP = true;
    }

    public void startDownload(DownloadMultiple dlgDownload, int tableIndex, byte[] imageBuffer, Board board) throws Exception {
        this.imageBuffer = imageBuffer;
        this.dlgDownload = dlgDownload;
        this.tableIndex = tableIndex;
        this.macAddress = board.getMac();
        this.ipTarget = board.getIpAddr();
        this.intfLocal = board.getIntfLocal();
        this.sendFirmwareUpdateMagicPacket();
        dlgDownload.setMessage("MBootServer.message.bootPStart");
        dlgDownload.setState("MBootServer.status.waiting");
        while (!this.bAbortBOOTP) {
            int numReadyKeys = this.selector.select(10000L);
            if (numReadyKeys == 0) {
                this.handleTimeout();
                continue;
            }
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid() || !key.isReadable()) continue;
                this.read(key);
            }
        }
    }

    public void closeChannels() {
        try {
            this.selector.close();
            this.channelBootP.disconnect();
            this.channelTftp.disconnect();
            this.channelTftpData.disconnect();
            this.channelBootP.close();
            this.channelTftp.close();
            this.channelTftpData.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void read(SelectionKey key) throws Exception {
        DatagramChannel channel = (DatagramChannel)key.channel();
        this.readBuffer.clear();
        InetSocketAddress saddr = (InetSocketAddress)channel.receive(this.readBuffer);
        this.remotePort = saddr.getPort();
        if (this.readBuffer.position() == 0) {
            return;
        }
        if (key.equals(this.keyBootP)) {
            this.processBootP();
        }
        if (key.equals(this.keyTftp)) {
            this.processTftp();
        }
        if (key.equals(this.keyTftpData)) {
            this.processTftpData();
        }
    }

    private void processBootP() throws IOException, WrongBinaryException {
        BootPPackage rPack = new BootPPackage(this.readBuffer.array());
        if (rPack.getOp() == 1 && rPack.gethType() == 1 && rPack.gethLen() == 6 && this.macAddress != null) {
            short bufType;
            int bufVersion;
            if (serverName.compareTo(rPack.getServerName().substring(0, serverName.length())) != 0) {
                throw new IOException();
            }
            if (this.macAddress.length > rPack.getcHAddr().length) {
                throw new IOException();
            }
            int i = 0;
            while (i < this.macAddress.length) {
                if (this.macAddress[i] != rPack.getcHAddr()[i]) {
                    return;
                }
                ++i;
            }
            int hwVersion = Integer.parseInt(rPack.getFileAsString().substring(0, 4), 16);
            int hwType = Integer.parseInt(rPack.getFileAsString().substring(4, 8), 16);
            if (hwVersion == 20 || hwVersion == 256) {
                bufVersion = ByteBuffer.wrap(this.imageBuffer, 252, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                bufType = ByteBuffer.wrap(this.imageBuffer, 248, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
            } else if (hwVersion == 40 || hwVersion == 768) {
                bufVersion = ByteBuffer.wrap(this.imageBuffer, 532, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                bufType = ByteBuffer.wrap(this.imageBuffer, 528, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
            } else {
                throw new WrongBinaryException();
            }
            if (!(BSFinder.getbForceImageUpdate().booleanValue() || bufVersion == hwVersion && bufType == hwType)) {
                throw new WrongBinaryException();
            }
            rPack.setOp((byte)2);
            rPack.setYiAddr(this.ipTarget.getAddress());
            if (this.intfLocal == null) {
                rPack.setSiAddr(this.determineLocalAddress(this.ipTarget));
            } else {
                rPack.setSiAddr(this.intfLocal.getAddress().getAddress());
            }
            this.bBootPPacketSeen = true;
            DatagramChannel channel = (DatagramChannel)this.keyBootP.channel();
            channel.send(rPack.getBuffer(), new InetSocketAddress(InetAddress.getByName("255.255.255.255"), 68));
        }
    }

    private void processTftp() throws IOException {
        byte[] buffer = this.readBuffer.array();
        if (buffer[0] != 0 || buffer[1] != 1) {
            buffer[0] = 0;
            buffer[1] = 5;
            buffer[2] = 0;
            buffer[3] = 4;
            String strErr = "Only RRQ is supported!";
            int i = 0;
            while (i < strErr.length()) {
                buffer[4 + i] = (byte)strErr.charAt(i);
                ++i;
            }
            buffer[4 + strErr.length()] = 0;
            this.channelTftp.send(ByteBuffer.wrap(buffer), new InetSocketAddress(this.ipTarget, this.remotePort));
        } else {
            this.dlgDownload.setMessage("MBootServer.message.bootPRun");
            this.dlgDownload.setState("MBootServer.status.tftp");
            if (this.keyTftpData == null) {
                Random random = new Random();
                this.keyTftpData = this.initSelector(this.channelTftpData, 32768 + random.nextInt(8191));
            }
            this.blockNumber = 1;
            this.buildTftpDataPacket();
            this.channelTftpData.send(this.writeBuffer, new InetSocketAddress(this.ipTarget, this.remotePort));
        }
    }

    private void processTftpData() throws IOException {
        byte[] buffer = this.readBuffer.array();
        if (buffer[0] == 0 && (buffer[1] & 0xFF) == 4 && (buffer[2] & 0xFF) == (this.blockNumber >> 8 & 0xFF) && (buffer[3] & 0xFF) == (this.blockNumber & 0xFF)) {
            if (this.imageBuffer.length < this.blockNumber * 512) {
                BSFinder.log(2, "Download finished");
                this.dlgDownload.setProgress(this.tableIndex, 100);
                this.dlgDownload.setMessage("MBootServer.message.dlFinished");
                this.abortBootPUpdate();
            } else {
                this.dlgDownload.setProgress(this.tableIndex, this.blockNumber * 512 * 100 / this.imageBuffer.length);
                ++this.blockNumber;
                this.buildTftpDataPacket();
                this.channelTftpData.send(this.writeBuffer, new InetSocketAddress(this.ipTarget, this.remotePort));
                this.toCount = 0;
            }
        }
    }

    private void handleTimeout() throws IOException {
        ++this.toCount;
        if (this.toCount > 1) {
            this.buildTftpDataPacket();
            this.channelTftpData.send(this.writeBuffer, new InetSocketAddress(this.ipTarget, this.remotePort));
            this.toCount = 0;
        }
        if (!this.bBootPPacketSeen) {
            this.sendFirmwareUpdateMagicPacket();
        }
    }

    private void buildTftpDataPacket() throws UnknownHostException {
        int length = this.imageBuffer.length < this.blockNumber * 512 ? this.imageBuffer.length % 512 : 512;
        this.writeBuffer.rewind();
        this.writeBuffer.put((byte)0);
        this.writeBuffer.put((byte)3);
        this.writeBuffer.put((byte)(this.blockNumber >> 8 & 0xFF));
        this.writeBuffer.put((byte)(this.blockNumber & 0xFF));
        this.writeBuffer.put(this.imageBuffer, (this.blockNumber - 1) * 512, length);
        this.writeBuffer.flip();
    }

    private byte[] determineLocalAddress(InetAddress ipTarget) throws SocketException {
        byte[] ips;
        Enumeration<NetworkInterface> netIntfs = NetworkInterface.getNetworkInterfaces();
        while (netIntfs.hasMoreElements()) {
            NetworkInterface netIntf = netIntfs.nextElement();
            if (netIntf.isLoopback() || !netIntf.isUp()) continue;
            for (InterfaceAddress interfaceAddress : netIntf.getInterfaceAddresses()) {
                if (interfaceAddress.getAddress().getAddress().length != 4) continue;
                short sPrefixLen = interfaceAddress.getNetworkPrefixLength();
                byte[] ipt = ipTarget.getAddress();
                ips = interfaceAddress.getAddress().getAddress();
                boolean isWrongInterface = false;
                int i = 0;
                while (i < 4) {
                    int j = 128;
                    while (j != 0 && sPrefixLen > 0) {
                        if ((ipt[i] & j) != (ips[i] & j)) {
                            isWrongInterface = true;
                            break;
                        }
                        sPrefixLen = (short)(sPrefixLen - 1);
                        j /= 2;
                    }
                    if (isWrongInterface) break;
                    ++i;
                }
                if (isWrongInterface) continue;
                return ips;
            }
        }
        ips = new byte[4];
        return ips;
    }

    private void sendFirmwareUpdateMagicPacket() throws IOException {
        byte[] bPacket = new byte[30];
        int iLoop = 0;
        while (iLoop < 6) {
            bPacket[iLoop] = -86;
            ++iLoop;
        }
        iLoop = 0;
        while (iLoop < 4) {
            int iMacLoop = 0;
            while (iMacLoop < 6) {
                bPacket[6 + iLoop * 6 + iMacLoop] = this.macAddress[iMacLoop];
                ++iMacLoop;
            }
            ++iLoop;
        }
        DatagramPacket sendPacket = new DatagramPacket(bPacket, bPacket.length, InetAddress.getByName("255.255.255.255"), 9);
        this.socketUpdate.send(sendPacket);
    }

    private SelectionKey initSelector(DatagramChannel channel, int port) throws IOException {
        channel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(port);
        DatagramSocket socket = channel.socket();
        socket.setReuseAddress(true);
        socket.bind(isa);
        return channel.register(this.selector, 1);
    }
}

