/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.utils;

import java.util.Locale;
import java.util.ResourceBundle;

public enum ResourceManager {
    INSTANCE;

    private Locale locale;
    private ResourceBundle resourceBundle;
    private final String resourceName = "messages";

    private ResourceManager() {
        Locale defloc = Locale.getDefault();
        switch (defloc.getLanguage()) {
            case "de": {
                this.locale = new Locale("de", "DE");
                break;
            }
            case "fr": {
                this.locale = new Locale("fr", "FR");
                break;
            }
            default: {
                this.locale = new Locale("en", "US");
            }
        }
        this.resourceBundle = ResourceBundle.getBundle("messages", this.locale);
        Locale.setDefault(this.locale);
    }

    public void changeResource(Locale locale) {
        this.resourceBundle = ResourceBundle.getBundle("messages", locale);
        this.setLocale(locale);
    }

    public String getString(String key) {
        return this.resourceBundle.getString(key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        Locale.setDefault(this.locale);
    }
}

