/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.unit.Board;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class UserSetup
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static UserSetup dialog = null;
    private JPanel contentPane;
    private JTextField ftUser;
    private JPasswordField ftPassword1;
    private JPasswordField ftPassword2;

    public static void configDialog(JFrame frame, Board board) {
        try {
            dialog = new UserSetup(frame, board);
            dialog.setDefaultCloseOperation(2);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserSetup(JFrame frame, Board board) throws PatternSyntaxException {
        super(frame);
        String node = "boards/board_" + board.getMacAsString().replace(":", "");
        BSFinder.setPrefsNode(node);
        this.setTitle(BSFinder.resourceManager.getString("SnmpSetup.Communities.title"));
        this.setBounds(100, 100, 496, 307);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        SpringLayout sl_contentPane = new SpringLayout();
        this.contentPane.setLayout(sl_contentPane);
        JLabel lblLogo = new JLabel("");
        lblLogo.setFocusable(false);
        lblLogo.setFocusTraversalKeysEnabled(false);
        sl_contentPane.putConstraint("North", (Component)lblLogo, 10, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("West", (Component)lblLogo, 10, "West", (Component)this.contentPane);
        lblLogo.setIcon(new ImageIcon(UserSetup.class.getResource("/images/logo_small.gif")));
        this.contentPane.add(lblLogo);
        JLabel lblUser = new JLabel(BSFinder.resourceManager.getString("SnmpSetup.Communities.lblUser.text"));
        sl_contentPane.putConstraint("North", (Component)lblUser, 28, "South", (Component)lblLogo);
        sl_contentPane.putConstraint("West", (Component)lblUser, 20, "West", (Component)this.contentPane);
        this.contentPane.add(lblUser);
        this.ftUser = new JTextField();
        sl_contentPane.putConstraint("South", (Component)this.ftUser, 3, "South", (Component)lblUser);
        sl_contentPane.putConstraint("East", (Component)this.ftUser, -10, "East", (Component)this.contentPane);
        this.ftUser.setText(BSFinder.prefs.get("username", "admin"));
        this.ftUser.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> UserSetup.this.ftUser.selectAll());
            }
        });
        this.contentPane.add(this.ftUser);
        JButton btnCancel = new JButton(BSFinder.resourceManager.getString("btnCancel.text"));
        sl_contentPane.putConstraint("South", (Component)btnCancel, -10, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)btnCancel, -10, "East", (Component)this.contentPane);
        btnCancel.addActionListener(event -> {
            this.setVisible(false);
            this.dispatchEvent(new WindowEvent(this, 201));
        });
        this.contentPane.add(btnCancel);
        JButton btnSet = new JButton(BSFinder.resourceManager.getString("btnSet.text"));
        sl_contentPane.putConstraint("South", (Component)btnSet, -10, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)btnSet, -10, "West", (Component)btnCancel);
        btnSet.addActionListener(event -> {
            String passwordChk;
            String password = new String(this.ftPassword1.getPassword());
            if (!password.equals(passwordChk = new String(this.ftPassword2.getPassword()))) {
                JOptionPane.showMessageDialog(this.contentPane, BSFinder.resourceManager.getString("SnmpSetup.Communities.message.diffPasswd"), BSFinder.resourceManager.getString("SnmpSetup.Communities.message.Error"), 0);
            } else {
                BSFinder.prefs.put("username", this.ftUser.getText());
                BSFinder.prefs.put("password", password);
                board.setUsername(this.ftUser.getText());
                board.setPassword(password);
                this.setVisible(false);
                this.dispatchEvent(new WindowEvent(this, 201));
            }
        });
        this.contentPane.add(btnSet);
        JLabel lblPassword1 = new JLabel(BSFinder.resourceManager.getString("SnmpSetup.Communities.lblPassword1.text"));
        sl_contentPane.putConstraint("North", (Component)lblPassword1, 19, "South", (Component)lblUser);
        sl_contentPane.putConstraint("West", (Component)lblPassword1, 0, "West", (Component)lblUser);
        this.contentPane.add(lblPassword1);
        this.ftPassword1 = new JPasswordField();
        sl_contentPane.putConstraint("South", (Component)this.ftPassword1, 3, "South", (Component)lblPassword1);
        sl_contentPane.putConstraint("East", (Component)this.ftPassword1, -10, "East", (Component)this.contentPane);
        this.ftPassword1.setText(BSFinder.prefs.get("password", "admin"));
        this.contentPane.add(this.ftPassword1);
        this.getRootPane().setDefaultButton(btnSet);
        JLabel lblPassword2 = new JLabel(BSFinder.resourceManager.getString("SnmpSetup.Communities.lblPassword2.text"));
        sl_contentPane.putConstraint("West", (Component)this.ftUser, 20, "East", (Component)lblPassword2);
        sl_contentPane.putConstraint("West", (Component)this.ftPassword1, 20, "East", (Component)lblPassword2);
        sl_contentPane.putConstraint("North", (Component)lblPassword2, 19, "South", (Component)lblPassword1);
        sl_contentPane.putConstraint("West", (Component)lblPassword2, 0, "West", (Component)lblUser);
        this.contentPane.add(lblPassword2);
        this.ftPassword2 = new JPasswordField();
        sl_contentPane.putConstraint("West", (Component)this.ftPassword2, 20, "East", (Component)lblPassword2);
        sl_contentPane.putConstraint("South", (Component)this.ftPassword2, 3, "South", (Component)lblPassword2);
        sl_contentPane.putConstraint("East", (Component)this.ftPassword2, -10, "East", (Component)this.contentPane);
        this.ftPassword2.setText(BSFinder.prefs.get("password", "admin"));
        this.contentPane.add(this.ftPassword2);
    }
}

