/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.workers;

import com.adventnet.snmp.beans.DataException;
import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.unit.PowerMeasure;
import com.brennenstuhl.utils.Constants;
import com.brennenstuhl.workers.AbstractBsHttpHandler;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.HttpHost;

public class HistoryHandler
extends AbstractBsHttpHandler {
    private volatile boolean isStopped = false;
    private static final long ntpDelta = 2208988800L;
    protected Constants.ChartMode chartMode = Constants.ChartMode.S10;

    public Constants.ChartMode getChartMode() {
        return this.chartMode;
    }

    public HistoryHandler(Constants.ChartMode chartMode, Board board) {
        super(board);
        this.url = this.getBoard().getIpAddr().getHostAddress();
        this.httpHost = new HttpHost(this.url, 80, "http");
        this.chartMode = chartMode;
    }

    public void clearHttpContext() {
        this.httpContext = null;
    }

    public Set<PowerMeasure> getData() throws DataException {
        int bBufferLen;
        int idxPage = 0;
        BSFinder.log(2, "Board: " + this.getBoard().asString());
        BSFinder.log(2, "Getting data by http in mode \"" + (Object)((Object)this.chartMode) + "\"");
        BSFinder.log(2, "---------START-------------");
        TreeSet<PowerMeasure> data = new TreeSet<PowerMeasure>();
        do {
            BSFinder.log(2, "Get table; start Index = " + Integer.toString(idxPage));
            ByteBuffer bBuffer = this.sendHttpGet(30, idxPage, this.chartMode == Constants.ChartMode.S10 ? 0 : 1);
            bBufferLen = bBuffer.position();
            byte[] b = bBuffer.array();
            int i = 0;
            if (bBufferLen >= 4) {
                i = 0;
                while (i < 4) {
                    if (b[i] == -1) break;
                    ++i;
                }
            }
            if (i < 4) break;
            long date = this.getStartDate(b);
            BSFinder.log(2, "Start date: " + date);
            if (date == 0L) break;
            List<PowerMeasure> values = this.parseData(date, b, bBufferLen);
            data.addAll(values);
            ++idxPage;
        } while (bBufferLen > 0);
        return data;
    }

    private long getStartDate(byte[] b) {
        long date = (long)(b[7] & 0xFF) * 0x1000000L + (long)(b[6] & 0xFF) * 65536L + (long)(b[5] & 0xFF) * 256L + (long)(b[4] & 0xFF) - 2208988800L;
        return date;
    }

    private List<PowerMeasure> parseData(long date, byte[] b, int bBufferLen) {
        LinkedList<PowerMeasure> data = new LinkedList<PowerMeasure>();
        long maxDelta = this.chartMode == Constants.ChartMode.H24 ? 86400L : 10L;
        int j = 8;
        int max = bBufferLen;
        while (j < max) {
            int v = (b[j + 1] & 0xFF) << 8 | b[j] & 0xFF;
            if (v < 40960) {
                data.add(new PowerMeasure(date * 1000L, v == 0 ? 0.1 : (double)(v / 10)));
            }
            j += 2;
            date += maxDelta;
        }
        return data;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void stop(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            sb.append("0x");
            sb.append(Constants.hexArray[v >>> 4]);
            sb.append(Constants.hexArray[v & 0xF]);
            sb.append(" ");
            ++j;
        }
        return sb.toString();
    }
}

