/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PrefObj {
    private static final int pieceLength = 6144;

    private static byte[] object2Bytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private static byte[][] breakIntoPieces(byte[] raw) {
        int numPieces = (raw.length + 6144 - 1) / 6144;
        byte[][] pieces = new byte[numPieces][];
        int i = 0;
        while (i < numPieces) {
            int startByte = i * 6144;
            int endByte = startByte + 6144;
            if (endByte > raw.length) {
                endByte = raw.length;
            }
            int length = endByte - startByte;
            pieces[i] = new byte[length];
            System.arraycopy(raw, startByte, pieces[i], 0, length);
            ++i;
        }
        return pieces;
    }

    private static void writePieces(Preferences prefs, String key, byte[][] pieces) throws BackingStoreException {
        Preferences node = prefs.node(key);
        node.clear();
        int i = 0;
        while (i < pieces.length) {
            node.putByteArray("" + i, pieces[i]);
            ++i;
        }
    }

    private static byte[][] readPieces(Preferences prefs, String key) throws BackingStoreException {
        Preferences node = prefs.node(key);
        String[] keys = node.keys();
        int numPieces = keys.length;
        byte[][] pieces = new byte[numPieces][];
        int i = 0;
        while (i < numPieces) {
            pieces[i] = node.getByteArray("" + i, null);
            ++i;
        }
        return pieces;
    }

    private static byte[] combinePieces(byte[][] pieces) {
        int length = 0;
        int i = 0;
        while (i < pieces.length) {
            length += pieces[i].length;
            ++i;
        }
        byte[] raw = new byte[length];
        int cursor = 0;
        int i2 = 0;
        while (i2 < pieces.length) {
            System.arraycopy(pieces[i2], 0, raw, cursor, pieces[i2].length);
            cursor += pieces[i2].length;
            ++i2;
        }
        return raw;
    }

    private static Object bytes2Object(byte[] raw) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(raw);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return o;
    }

    public static void putObject(Preferences prefs, String key, Object o) throws IOException, BackingStoreException, ClassNotFoundException {
        byte[] raw = PrefObj.object2Bytes(o);
        byte[][] pieces = PrefObj.breakIntoPieces(raw);
        PrefObj.writePieces(prefs, key, pieces);
    }

    public static Object getObject(Preferences prefs, String key) throws IOException, BackingStoreException, ClassNotFoundException {
        byte[][] pieces = PrefObj.readPieces(prefs, key);
        byte[] raw = PrefObj.combinePieces(pieces);
        Object o = PrefObj.bytes2Object(raw);
        return o;
    }
}

