/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.unit;

import com.brennenstuhl.utils.ArraysN;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class MBootPacket {
    public byte[] ip = null;
    public byte[] nm = null;
    public byte[] gw = null;
    public byte[] d1 = null;
    public byte[] d2 = null;
    public String hostname = null;
    public String domainname = null;
    protected byte[] buf = null;
    protected int length = 0;
    public static final byte[] REQUEST_ID = "admin\u0000".getBytes();
    public static final byte[] MAGIC_COOKIE = new byte[]{99, -126, 83, 99};
    public static final int BOOTP_MAX_SIZE = 600;
    public static final byte BOOTP_OPTION_NETMASK = 1;
    public static final byte BOOTP_OPTION_GATEWAY = 3;
    public static final byte BOOTP_OPTION_DNS = 6;
    public static final byte BOOTP_OPTION_HOSTNAME = 12;
    public static final byte BOOTP_OPTION_BOOTFILE = 13;
    public static final byte BOOTP_OPTION_DOMAIN = 15;
    public static final byte BOOTP_OPTION_BROADCAST = 28;
    public static final byte BOOTP_OPTION_NISDOMAIN = 40;

    public MBootPacket(DatagramPacket dp) {
        this.length = dp.getLength();
        this.buf = new byte[this.length];
        ArraysN.copy(this.buf, 0, dp.getData(), dp.getOffset(), this.length);
    }

    public MBootPacket(byte[] ip, byte[] nm, byte[] gw, byte[] d1, byte[] d2, String hostname, String domainname) {
        this.buf = new byte[600];
        Arrays.fill(this.buf, (byte)0);
        this.buf[0] = 2;
        this.buf[1] = 1;
        this.buf[2] = 6;
        this.buf[3] = -1;
        int n32 = 305419896;
        this.buf[7] = (byte)n32;
        this.buf[6] = (byte)(n32 >>= 8);
        this.buf[5] = (byte)(n32 >>= 8);
        this.buf[4] = (byte)(n32 >>= 8);
        n32 >>= 8;
        int n16 = 0;
        this.buf[9] = (byte)n16;
        n16 = (short)(n16 >> 8);
        this.buf[8] = (byte)n16;
        n16 = (short)(n16 >> 8);
        n16 = 0;
        this.buf[11] = (byte)n16;
        n16 = (short)(n16 >> 8);
        this.buf[10] = (byte)n16;
        n16 = (short)(n16 >> 8);
        n32 = 0;
        if (ip != null) {
            ArraysN.copy(this.buf, 16, ip, 0, 4);
        }
        try {
            byte[] ipAddr = InetAddress.getLocalHost().getAddress();
            ArraysN.copy(this.buf, 20, ipAddr, 0, 4);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        ArraysN.copy(this.buf, 44, REQUEST_ID);
        this.length = 236;
        ArraysN.copy(this.buf, this.length, MAGIC_COOKIE);
        this.length += MAGIC_COOKIE.length;
        if (nm != null) {
            this.buf[this.length++] = 1;
            this.buf[this.length++] = 4;
            ArraysN.copy(this.buf, this.length, nm, 0, 4);
            this.length += 4;
        }
        if (gw != null) {
            this.buf[this.length++] = 3;
            this.buf[this.length++] = 4;
            ArraysN.copy(this.buf, this.length, gw, 0, 4);
            this.length += 4;
        }
        if (d1 == null) {
            d1 = d2;
            d2 = null;
        }
        if (d1 != null) {
            this.buf[this.length++] = 6;
            this.buf[this.length++] = (byte)(d2 == null ? 4 : 8);
            ArraysN.copy(this.buf, this.length, d1, 0, 4);
            this.length += 4;
            if (d2 != null) {
                ArraysN.copy(this.buf, this.length, d2, 0, 4);
                this.length += 4;
            }
        }
        if (hostname != null && hostname.length() != 0) {
            this.buf[this.length++] = 12;
            this.buf[this.length++] = (byte)hostname.length();
            ArraysN.copy(this.buf, this.length, hostname.getBytes());
            this.length += hostname.length();
        }
        if (domainname != null && domainname.length() != 0) {
            this.buf[this.length++] = 15;
            this.buf[this.length++] = (byte)domainname.length();
            ArraysN.copy(this.buf, this.length, domainname.getBytes());
            this.length += domainname.length();
        }
        this.buf[this.length++] = -1;
    }

    public synchronized byte[] getBuf() {
        return this.buf;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void parse() {
        this.ip = null;
        this.nm = null;
        this.gw = null;
        this.d1 = null;
        this.d2 = null;
        this.hostname = null;
        this.domainname = null;
        if (this.buf != null && this.length >= 16) {
            this.ip = new byte[4];
            ArraysN.copy(this.ip, 0, this.buf, 12, 4);
            int ptr = 236;
            if (this.length >= ptr + MAGIC_COOKIE.length && ArraysN.compare(this.buf, ptr, MAGIC_COOKIE)) {
                ptr += MAGIC_COOKIE.length;
                while (ptr < this.length && this.buf[ptr] != -1) {
                    byte opt = this.buf[ptr++];
                    byte optlen = this.buf[ptr++];
                    switch (opt) {
                        case 1: {
                            this.nm = new byte[4];
                            ArraysN.copy(this.nm, this.buf, ptr, 4);
                            break;
                        }
                        case 3: {
                            this.gw = new byte[4];
                            ArraysN.copy(this.gw, this.buf, ptr, 4);
                            break;
                        }
                        case 6: {
                            this.d1 = new byte[4];
                            ArraysN.copy(this.d1, this.buf, ptr, 4);
                            if (optlen < 8) break;
                            this.d2 = new byte[4];
                            ArraysN.copy(this.d2, this.buf, ptr + 4, 4);
                            break;
                        }
                        case 12: {
                            this.hostname = new String(this.buf, ptr, (int)optlen);
                            break;
                        }
                        case 15: {
                            this.domainname = new String(this.buf, ptr, (int)optlen);
                        }
                    }
                    ptr += optlen;
                }
            }
        }
    }
}

