/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui.renderer;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.thread.FinderThread;
import com.brennenstuhl.unit.Board;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class InfoCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static FinderThread objFinder;

    private String createTableRow(String description, String data, String state) {
        String result = "<tr><td>" + description + "</td><td>" + data + "</td><td>" + state + "</td></tr>";
        return result;
    }

    private String createTableRow(String description, String data) {
        String result = "<tr><td>" + description + "</td><td colspan=\"2\">" + data + "</td></tr>";
        return result;
    }

    private String createFeatureString(int feature) {
        String result = "";
        result = feature > 0 ? "\u2713" : "\u2717";
        return result;
    }

    private String createTypeString(int type) {
        String result;
        BSFinder.resourceManager.getString("DownloadMultiple.this.title");
        switch (type) {
            case 0: {
                result = "Eval";
                break;
            }
            default: {
                result = BSFinder.resourceManager.getString("bsFinder.InfoCellRenderer.hover.Series");
            }
        }
        return result;
    }

    private String createVersionString(int version, int type) {
        switch (version) {
            case 0: {
                version = 256;
                break;
            }
            case 110: {
                version = type == 0 ? 20 : 256;
            }
        }
        String result = String.valueOf(String.valueOf((version & 0xFF00) >> 8)) + "." + String.valueOf(version & 0xFF);
        return result;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel hover = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Font font = new Font("monospaced", 1, 12);
        this.setFont(font);
        objFinder = FinderThread.getInstance();
        Board board = objFinder.getBoard(row);
        String pathValue = "<html><table><th>" + BSFinder.resourceManager.getString("bsFinder.InfoCellRenderer.hover.Description") + "</th><tr><td colspan=\"3\"><hr></td></tr>" + this.createTableRow("Features:", BSFinder.resourceManager.getString("bsFinder.InfoCellRenderer.hover.Temperature"), this.createFeatureString(board.getBoardFeatures() & 1)) + this.createTableRow("", "ext. Flash", this.createFeatureString(board.getBoardFeatures() & 2)) + this.createTableRow("", "Latch", this.createFeatureString(board.getBoardFeatures() & 8)) + this.createTableRow("Type:", this.createTypeString(board.getBoardType())) + this.createTableRow("Version:", this.createVersionString(board.getBoardId(), board.getBoardType())) + this.createTableRow("IP-Gateway:", board.getIpGateway().getHostAddress()) + this.createTableRow("IP-Netmask:", board.getIpNetmask().getHostAddress()) + "</table></html>";
        hover.setToolTipText(pathValue);
        if (!board.isActive()) {
            if (isSelected) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(Color.lightGray);
            }
        } else if (isSelected) {
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setForeground(table.getForeground());
        }
        return hover;
    }
}

