/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui.renderer;

import com.brennenstuhl.gui.BSChartPanel;
import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.gui.ChartWindow;
import com.brennenstuhl.unit.PowerMeasure;
import com.brennenstuhl.utils.BSLogFormatter;
import com.brennenstuhl.utils.Constants;
import com.brennenstuhl.utils.PrefObj;
import com.brennenstuhl.workers.HistoryHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public abstract class AbstractHistoryRenderer {
    private ChartWindow historyWindow;
    private BSChartPanel chartPanel;
    private HistoryHandler historyHandler;

    protected AbstractHistoryRenderer(ChartWindow historyWindow) {
        this.historyWindow = historyWindow;
    }

    public ChartWindow getHistoryWindow() {
        return this.historyWindow;
    }

    public void setHistoryWindow(ChartWindow historyWindow) {
        this.historyWindow = historyWindow;
    }

    public HistoryHandler getHistoryHandler() {
        return this.historyHandler;
    }

    public void setHistoryHandler(HistoryHandler historyHandler) {
        this.historyHandler = historyHandler;
    }

    public BSChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setChartPanel(BSChartPanel chartPanel) {
        this.chartPanel = chartPanel;
    }

    protected JFreeChart createChart(Constants.ChartMode chartMode) {
        TimeSeries s = new TimeSeries((Comparable)((Object)chartMode.value()));
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s);
        LogAxis yAxis = new LogAxis(BSFinder.resourceManager.getString("ChartWindow.this.chart.y"));
        TickUnits units = new TickUnits();
        units.add((TickUnit)new NumberTickUnit(0.1));
        units.add((TickUnit)new NumberTickUnit(1.0));
        units.add((TickUnit)new NumberTickUnit(10.0));
        units.add((TickUnit)new NumberTickUnit(100.0));
        units.add((TickUnit)new NumberTickUnit(1000.0));
        units.add((TickUnit)new NumberTickUnit(10000.0));
        yAxis.setStandardTickUnits((TickUnitSource)units);
        yAxis.setRange(0.07, 15000.0);
        yAxis.setDefaultAutoRange(yAxis.getRange());
        yAxis.setNumberFormatOverride((NumberFormat)new BSLogFormatter());
        DateAxis timeAxis = new DateAxis(BSFinder.resourceManager.getString("ChartWindow.this.chart.x"));
        timeAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", BSFinder.resourceManager.getLocale()));
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)timeAxis, (ValueAxis)yAxis, null);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setDomainPannable(true);
        XYLineAndShapeRenderer r = new XYLineAndShapeRenderer(true, true);
        r.setSeriesShape(0, (Shape)new Ellipse2D.Float(-1.0f, -1.0f, 2.0f, 2.0f));
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", BSFinder.resourceManager.getLocale());
        DecimalFormat nf = new DecimalFormat("# ##0.0");
        DecimalFormatSymbols dfs = nf.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        String pattern = String.valueOf(BSFinder.resourceManager.getString("ChartWindow.this.chart.x")) + ": {1} " + BSFinder.resourceManager.getString("ChartWindow.this.chart.y") + ": {2} W";
        StandardXYToolTipGenerator tg = new StandardXYToolTipGenerator(pattern, (DateFormat)df, (NumberFormat)nf);
        r.setBaseToolTipGenerator((XYToolTipGenerator)tg);
        plot.setRenderer((XYItemRenderer)r);
        JFreeChart chart = new JFreeChart(BSFinder.resourceManager.getString("ChartWindow.this.chart" + chartMode.value() + ".title"), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    protected void updateChart() throws Exception {
        TimeSeriesCollection dataSet = (TimeSeriesCollection)this.chartPanel.getChart().getXYPlot().getDataset(0);
        TimeSeries set = (TimeSeries)dataSet.getSeries().get(0);
        this.setData(set, this.historyHandler.getData(), this.historyHandler.getChartMode());
    }

    private void setData(TimeSeries set, Set<PowerMeasure> data, Constants.ChartMode chartMode) {
        if (data != null && data.size() > 0) {
            long maxDelta = chartMode == Constants.ChartMode.H24 ? 86400 : 10;
            Date lastDate = null;
            if (!set.isEmpty()) {
                long tmp = ((TimeSeriesDataItem)set.getItems().get(set.getItemCount() - 1)).getPeriod().getFirstMillisecond();
                lastDate = new Date(tmp);
            }
            for (PowerMeasure item : data) {
                long delta = 0L;
                if (lastDate != null) {
                    delta = (item.getTime() - lastDate.getTime()) / 1000L;
                    if (delta < maxDelta) continue;
                    if (delta > maxDelta) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(lastDate.getTime());
                        c.add(13, (int)maxDelta);
                        set.addOrUpdate(RegularTimePeriod.createInstance(Millisecond.class, (Date)c.getTime(), (TimeZone)TimeZone.getDefault()), null);
                    }
                }
                set.addOrUpdate(RegularTimePeriod.createInstance(Millisecond.class, (Date)item.getDate(), (TimeZone)TimeZone.getDefault()), (Number)item.getValue());
                lastDate = item.getDate();
            }
        }
    }

    public static synchronized void restoreChart(BSChartPanel chartPanel) throws ClassNotFoundException, IOException, BackingStoreException {
        Preferences prefs = Preferences.userRoot();
        StringBuilder node = new StringBuilder();
        node.append("window");
        node.append("/");
        node.append("history");
        node.append("/");
        node.append("Chart");
        node.append("/");
        node.append(chartPanel.is24h() ? "24h" : "10s");
        prefs = prefs.node("/bsFinder/" + node.toString());
        if (prefs.keys().length != 0) {
            chartPanel.getChart().setAntiAlias(prefs.getBoolean("AntiAlias", true));
            TextTitle title = (TextTitle)PrefObj.getObject(prefs, "Title");
            chartPanel.getChart().setTitle(title);
            node.append("/");
            node.append("Plot");
            prefs = prefs.node("/bsFinder/" + node.toString());
            XYPlot p = chartPanel.getChart().getXYPlot();
            Object tmp = PrefObj.getObject(prefs, "OutlinePaint");
            p.setOutlinePaint((Paint)tmp);
            tmp = PrefObj.getObject(prefs, "Background");
            p.setBackgroundPaint((Paint)tmp);
            tmp = PrefObj.getObject(prefs, "Insets");
            p.setInsets((RectangleInsets)tmp);
            tmp = PrefObj.getObject(prefs, "Orientation");
            p.setOrientation((PlotOrientation)tmp);
            tmp = PrefObj.getObject(prefs, "XAxis");
            p.setDomainAxis((ValueAxis)tmp);
            tmp = PrefObj.getObject(prefs, "YAxis");
            p.setRangeAxis((ValueAxis)tmp);
            chartPanel.resetChart();
            node.append("/");
            node.append("OutlineStroke");
            prefs = prefs.node("/bsFinder/" + node.toString());
            float width = prefs.getFloat("width", 1.0f);
            int cap = prefs.getInt("cap", 2);
            int join = prefs.getInt("join", 0);
            float miterlimit = prefs.getFloat("miterlimit", 10.0f);
            float dash_phase = prefs.getFloat("dash_phase", 0.0f);
            node.append("/");
            node.append("dash");
            prefs = prefs.node("/bsFinder/" + node.toString());
            int size = prefs.keys().length;
            float[] dash = null;
            if (size != 0) {
                dash = new float[size];
                int i = 0;
                while (i < dash.length) {
                    dash[i] = prefs.getFloat(String.valueOf(i), 1.0f);
                    ++i;
                }
            }
            p.setOutlineStroke((Stroke)new BasicStroke(width, cap, join, miterlimit, dash, dash_phase));
        }
    }

    public static synchronized void persistChart(BSChartPanel chartPanel) throws ClassNotFoundException, IOException, BackingStoreException {
        Preferences prefs = Preferences.userRoot();
        StringBuilder node = new StringBuilder();
        node.append("window");
        node.append("/");
        node.append("history");
        node.append("/");
        node.append("Chart");
        node.append("/");
        node.append(chartPanel.is24h() ? "24h" : "10s");
        prefs = prefs.node("/bsFinder/" + node.toString());
        prefs.putBoolean("AntiAlias", chartPanel.getChart().getAntiAlias());
        PrefObj.putObject(prefs, "Title", chartPanel.getChart().getTitle());
        node.append("/");
        node.append("Plot");
        prefs = prefs.node("/bsFinder/" + node.toString());
        XYPlot p = chartPanel.getChart().getXYPlot();
        PrefObj.putObject(prefs, "OutlinePaint", p.getOutlinePaint());
        PrefObj.putObject(prefs, "Background", p.getBackgroundPaint());
        PrefObj.putObject(prefs, "Insets", p.getInsets());
        PrefObj.putObject(prefs, "Orientation", p.getOrientation());
        PrefObj.putObject(prefs, "XAxis", p.getDomainAxis());
        PrefObj.putObject(prefs, "YAxis", p.getRangeAxis());
        node.append("/");
        node.append("OutlineStroke");
        prefs = prefs.node("/bsFinder/" + node.toString());
        BasicStroke s = (BasicStroke)p.getOutlineStroke();
        prefs.putFloat("width", s.getLineWidth());
        prefs.putInt("cap", s.getEndCap());
        prefs.putInt("join", s.getLineJoin());
        prefs.putFloat("miterlimit", s.getMiterLimit());
        prefs.putFloat("dash_phase", s.getDashPhase());
        node.append("/");
        node.append("dash");
        prefs = prefs.node("/bsFinder/" + node.toString());
        float[] d = s.getDashArray();
        if (d != null) {
            int i = 0;
            while (i < d.length) {
                prefs.putFloat(String.valueOf(i), d[i]);
                ++i;
            }
        }
        prefs.flush();
    }
}

