/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.thread.FinderThread;
import com.brennenstuhl.unit.Board;
import com.brennenstuhl.utils.PortFormatter;
import com.brennenstuhl.utils.RegexFormatter;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class IpSetup
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static IpSetup dialog = null;
    private static FinderThread objFinder = null;
    private static String regexIP = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private JPanel contentPane;
    private JFormattedTextField ftfIp = null;
    private JFormattedTextField ftfNetmask = null;
    private JFormattedTextField ftfGateway = null;
    private JFormattedTextField ftfPort = null;

    public static void configDialog(JFrame frame, FinderThread finder, Board board) {
        try {
            objFinder = finder;
            dialog = new IpSetup(frame, board);
            dialog.setDefaultCloseOperation(2);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IpSetup(JFrame frame, Board board) throws PatternSyntaxException {
        super(frame);
        this.setTitle(BSFinder.resourceManager.getString("IpSetup.this.title"));
        this.setBounds(100, 100, 555, 370);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        SpringLayout sl_contentPane = new SpringLayout();
        this.contentPane.setLayout(sl_contentPane);
        JPanel grpDevice = new JPanel();
        grpDevice.setFocusTraversalKeysEnabled(false);
        grpDevice.setFocusable(false);
        sl_contentPane.putConstraint("South", (Component)grpDevice, 80, "North", (Component)this.contentPane);
        grpDevice.setBorder(new TitledBorder(null, BSFinder.resourceManager.getString("TagDevice"), 4, 2, null, null));
        sl_contentPane.putConstraint("North", (Component)grpDevice, 20, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)grpDevice, -20, "East", (Component)this.contentPane);
        this.contentPane.add(grpDevice);
        SpringLayout sl_grpDevice = new SpringLayout();
        grpDevice.setLayout(sl_grpDevice);
        JLabel lblLogo = new JLabel("");
        lblLogo.setFocusable(false);
        lblLogo.setFocusTraversalKeysEnabled(false);
        sl_contentPane.putConstraint("West", (Component)grpDevice, 15, "East", (Component)lblLogo);
        sl_contentPane.putConstraint("North", (Component)lblLogo, 10, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("West", (Component)lblLogo, 10, "West", (Component)this.contentPane);
        lblLogo.setIcon(new ImageIcon(IpSetup.class.getResource("/images/logo_small.gif")));
        this.contentPane.add(lblLogo);
        JLabel lblMacAddress = new JLabel(BSFinder.resourceManager.getString("IpSetup.lblMacAddress.text"));
        lblMacAddress.setFocusable(false);
        lblMacAddress.setFocusTraversalKeysEnabled(false);
        sl_grpDevice.putConstraint("North", (Component)lblMacAddress, 7, "North", (Component)grpDevice);
        sl_grpDevice.putConstraint("West", (Component)lblMacAddress, 10, "West", (Component)grpDevice);
        grpDevice.add(lblMacAddress);
        JFormattedTextField ftfMacAddress = new JFormattedTextField();
        ftfMacAddress.setFocusable(false);
        ftfMacAddress.setFocusTraversalKeysEnabled(false);
        sl_grpDevice.putConstraint("West", (Component)ftfMacAddress, 10, "East", (Component)lblMacAddress);
        ftfMacAddress.setEditable(false);
        sl_grpDevice.putConstraint("South", (Component)ftfMacAddress, 0, "South", (Component)lblMacAddress);
        sl_grpDevice.putConstraint("East", (Component)ftfMacAddress, -20, "East", (Component)grpDevice);
        grpDevice.add(ftfMacAddress);
        JRadioButton rdbtnDhcp = new JRadioButton(BSFinder.resourceManager.getString("IpSetup.rdbtnDhcp.text"));
        rdbtnDhcp.addActionListener(event -> dialog.setState(false));
        sl_contentPane.putConstraint("North", (Component)rdbtnDhcp, 10, "South", (Component)lblLogo);
        sl_contentPane.putConstraint("West", (Component)rdbtnDhcp, 20, "West", (Component)this.contentPane);
        this.contentPane.add(rdbtnDhcp);
        JRadioButton rdbtnManual = new JRadioButton(BSFinder.resourceManager.getString("IpSetup.rdbtnManual.text"));
        rdbtnManual.addActionListener(event -> dialog.setState(true));
        sl_contentPane.putConstraint("North", (Component)rdbtnManual, 0, "North", (Component)rdbtnDhcp);
        sl_contentPane.putConstraint("West", (Component)rdbtnManual, 20, "East", (Component)rdbtnDhcp);
        this.contentPane.add(rdbtnManual);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(rdbtnDhcp);
        btnGroup.add(rdbtnManual);
        JLabel lblIp = new JLabel(BSFinder.resourceManager.getString("IpSetup.lblIp.text"));
        sl_contentPane.putConstraint("North", (Component)lblIp, 26, "South", (Component)rdbtnManual);
        sl_contentPane.putConstraint("West", (Component)lblIp, 20, "West", (Component)this.contentPane);
        this.contentPane.add(lblIp);
        RegexFormatter fmIp1 = new RegexFormatter(regexIP);
        fmIp1.setOverwriteMode(false);
        this.ftfIp = new JFormattedTextField(fmIp1);
        this.ftfIp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> IpSetup.this.ftfIp.selectAll());
            }
        });
        sl_contentPane.putConstraint("North", (Component)this.ftfIp, 0, "North", (Component)lblIp);
        sl_contentPane.putConstraint("West", (Component)this.ftfIp, 73, "East", (Component)lblIp);
        sl_contentPane.putConstraint("East", (Component)this.ftfIp, -20, "East", (Component)this.contentPane);
        this.contentPane.add(this.ftfIp);
        JLabel lblNetmask = new JLabel(BSFinder.resourceManager.getString("IpSetup.lblNetmask.text"));
        sl_contentPane.putConstraint("North", (Component)lblNetmask, 10, "South", (Component)lblIp);
        sl_contentPane.putConstraint("West", (Component)lblNetmask, 20, "West", (Component)this.contentPane);
        this.contentPane.add(lblNetmask);
        RegexFormatter fmIp2 = new RegexFormatter(regexIP);
        fmIp2.setOverwriteMode(false);
        this.ftfNetmask = new JFormattedTextField(fmIp2);
        this.ftfNetmask.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> IpSetup.this.ftfNetmask.selectAll());
            }
        });
        sl_contentPane.putConstraint("North", (Component)this.ftfNetmask, 0, "North", (Component)lblNetmask);
        sl_contentPane.putConstraint("West", (Component)this.ftfNetmask, 0, "West", (Component)this.ftfIp);
        sl_contentPane.putConstraint("East", (Component)this.ftfNetmask, 0, "East", (Component)this.ftfIp);
        this.contentPane.add(this.ftfNetmask);
        JLabel lblGateway = new JLabel(BSFinder.resourceManager.getString("IpSetup.lblGateway.text"));
        sl_contentPane.putConstraint("North", (Component)lblGateway, 10, "South", (Component)lblNetmask);
        sl_contentPane.putConstraint("West", (Component)lblGateway, 20, "West", (Component)this.contentPane);
        this.contentPane.add(lblGateway);
        RegexFormatter fmIp3 = new RegexFormatter(regexIP);
        fmIp3.setOverwriteMode(false);
        this.ftfGateway = new JFormattedTextField(fmIp3);
        this.ftfGateway.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> IpSetup.this.ftfGateway.selectAll());
            }
        });
        sl_contentPane.putConstraint("North", (Component)this.ftfGateway, 0, "North", (Component)lblGateway);
        sl_contentPane.putConstraint("West", (Component)this.ftfGateway, 0, "West", (Component)this.ftfIp);
        sl_contentPane.putConstraint("East", (Component)this.ftfGateway, 0, "East", (Component)this.ftfIp);
        this.contentPane.add(this.ftfGateway);
        JLabel lblHttpPort = new JLabel(BSFinder.resourceManager.getString("IpSetup.lblHttpPort.text"));
        sl_contentPane.putConstraint("North", (Component)lblHttpPort, 10, "South", (Component)lblGateway);
        sl_contentPane.putConstraint("West", (Component)lblHttpPort, 20, "West", (Component)this.contentPane);
        this.contentPane.add(lblHttpPort);
        PortFormatter fmPort = new PortFormatter();
        fmPort.setOverwriteMode(false);
        this.ftfPort = new JFormattedTextField(fmPort);
        this.ftfPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(() -> IpSetup.this.ftfPort.selectAll());
            }
        });
        sl_contentPane.putConstraint("North", (Component)this.ftfPort, 0, "North", (Component)lblHttpPort);
        sl_contentPane.putConstraint("West", (Component)this.ftfPort, 0, "West", (Component)this.ftfIp);
        sl_contentPane.putConstraint("East", (Component)this.ftfPort, 0, "East", (Component)this.ftfIp);
        this.contentPane.add(this.ftfPort);
        JButton btnCancel = new JButton(BSFinder.resourceManager.getString("btnCancel.text"));
        sl_contentPane.putConstraint("North", (Component)btnCancel, 29, "South", (Component)this.ftfPort);
        sl_contentPane.putConstraint("South", (Component)btnCancel, 52, "South", (Component)this.ftfPort);
        btnCancel.addActionListener(event -> {
            this.setVisible(false);
            this.dispatchEvent(new WindowEvent(this, 201));
        });
        sl_contentPane.putConstraint("East", (Component)btnCancel, -20, "East", (Component)this.contentPane);
        this.contentPane.add(btnCancel);
        JButton btnSet = new JButton(BSFinder.resourceManager.getString("btnSet.text"));
        sl_contentPane.putConstraint("North", (Component)btnSet, 29, "South", (Component)this.ftfPort);
        sl_contentPane.putConstraint("South", (Component)btnSet, 52, "South", (Component)this.ftfPort);
        sl_contentPane.putConstraint("East", (Component)btnSet, -10, "West", (Component)btnCancel);
        btnSet.addActionListener(event -> {
            try {
                this.ftfIp.commitEdit();
                this.ftfNetmask.commitEdit();
                this.ftfGateway.commitEdit();
                this.ftfPort.commitEdit();
                if (rdbtnDhcp.isSelected()) {
                    objFinder.sendConfig(board, InetAddress.getByName("0.0.0.0"), InetAddress.getByName("0.0.0.0"), InetAddress.getByName("0.0.0.0"), Short.parseShort(this.ftfPort.getValue().toString()));
                } else {
                    objFinder.sendConfig(board, InetAddress.getByName(this.ftfIp.getValue().toString()), InetAddress.getByName(this.ftfNetmask.getValue().toString()), InetAddress.getByName(this.ftfGateway.getValue().toString()), Short.parseShort(this.ftfPort.getValue().toString()));
                }
            }
            catch (NumberFormatException | UnknownHostException | ParseException e1) {
                BSFinder.log(2, e1.getLocalizedMessage());
            }
            this.setVisible(false);
            this.dispatchEvent(new WindowEvent(this, 201));
        });
        this.contentPane.add(btnSet);
        this.getRootPane().setDefaultButton(btnSet);
        if (board != null) {
            ftfMacAddress.setText(board.getMacAsString());
            this.ftfIp.setText(board.getIpAddr().getHostAddress());
            this.ftfNetmask.setText(board.getIpNetmask().getHostAddress());
            this.ftfGateway.setText(board.getIpGateway().getHostAddress());
            this.ftfPort.setText(Short.toString(board.getHttpPort()));
            if (board.getIpAddr().getHostAddress().equals("0.0.0.0")) {
                rdbtnDhcp.setEnabled(false);
                rdbtnManual.setSelected(true);
                this.setState(true);
            } else {
                rdbtnDhcp.setSelected(true);
                this.setState(false);
            }
        }
    }

    public void setState(Boolean state) {
        this.ftfIp.setEnabled(state);
        this.ftfNetmask.setEnabled(state);
        this.ftfGateway.setEnabled(state);
    }
}

