/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.gui.renderer.UpdateTableCellRenderer;
import com.brennenstuhl.thread.Bootp;
import com.brennenstuhl.unit.Board;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class DownloadMultiple
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static DownloadMultiple dialog = null;
    private File selectedFile = new File(BSFinder.prefs.get("target_file", ""));
    private JPanel contentPane;
    private DefaultTableModel defaultModel;
    private JButton btnProgram = null;
    private JButton btnClose = null;
    private JButton btnCancel = null;
    private JLabel lblState = null;
    private JLabel lblMessage = null;
    private JTextField tfFile = null;
    private JTable table;
    private Bootp bootp = null;

    public static void downloadDialog(JFrame frame, List<Board> boardList) {
        try {
            dialog = new DownloadMultiple(frame, boardList);
            dialog.setDefaultCloseOperation(2);
            dialog.setModalityType(Dialog.ModalityType.MODELESS);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRunning() {
        return dialog != null;
    }

    private Boolean fileExists(String path) {
        File f = new File(path);
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return false;
    }

    public void setProgress(int row, int percentage) {
        this.table.getModel().setValueAt(percentage, row, 3);
    }

    public DownloadMultiple(JFrame frame, List<Board> boardList) {
        super(frame);
        this.setTitle(BSFinder.resourceManager.getString("DownloadMultiple.this.title"));
        this.setBounds(100, 100, 555, 370);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(null);
        this.setContentPane(this.contentPane);
        SpringLayout sl_contentPane = new SpringLayout();
        this.contentPane.setLayout(sl_contentPane);
        JLabel lblLogo = new JLabel();
        lblLogo.setIcon(new ImageIcon(DownloadMultiple.class.getResource("/images/logo.gif")));
        sl_contentPane.putConstraint("North", (Component)lblLogo, 10, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("West", (Component)lblLogo, 10, "West", (Component)this.contentPane);
        this.contentPane.add(lblLogo);
        JPanel grpBinFile = new JPanel();
        sl_contentPane.putConstraint("North", (Component)grpBinFile, 20, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("West", (Component)grpBinFile, 10, "East", (Component)lblLogo);
        sl_contentPane.putConstraint("South", (Component)grpBinFile, 70, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)grpBinFile, -10, "East", (Component)this.contentPane);
        grpBinFile.setBorder(new TitledBorder(null, BSFinder.resourceManager.getString("DownloadMultiple.grpBinFile.borderTitle"), 4, 2, null, null));
        this.contentPane.add(grpBinFile);
        SpringLayout sl_grpBinFile = new SpringLayout();
        grpBinFile.setLayout(sl_grpBinFile);
        this.tfFile = new JTextField();
        sl_grpBinFile.putConstraint("West", (Component)this.tfFile, 10, "West", (Component)grpBinFile);
        this.tfFile.setText(this.selectedFile.getAbsolutePath());
        grpBinFile.add(this.tfFile);
        this.tfFile.setColumns(10);
        JButton btnBinFile = new JButton(BSFinder.resourceManager.getString("btnBinFile.text"));
        btnBinFile.addActionListener(event -> {
            JFileChooser fc = new JFileChooser(this.tfFile.getText());
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.selectedFile = fc.getSelectedFile();
                this.tfFile.setText(this.selectedFile.getAbsolutePath());
                BSFinder.prefs.put("target_file", this.selectedFile.getAbsolutePath());
                this.btnProgram.setEnabled(true);
            }
        });
        sl_grpBinFile.putConstraint("North", (Component)this.tfFile, 3, "North", (Component)btnBinFile);
        sl_grpBinFile.putConstraint("East", (Component)this.tfFile, -10, "West", (Component)btnBinFile);
        sl_grpBinFile.putConstraint("North", (Component)btnBinFile, 0, "North", (Component)grpBinFile);
        sl_grpBinFile.putConstraint("East", (Component)btnBinFile, -10, "East", (Component)grpBinFile);
        grpBinFile.add(btnBinFile);
        this.btnClose = new JButton(BSFinder.resourceManager.getString("btnClose.text"));
        sl_contentPane.putConstraint("East", (Component)this.btnClose, -10, "East", (Component)this.contentPane);
        this.btnClose.addActionListener(event -> {
            this.setVisible(false);
            this.dispatchEvent(new WindowEvent(this, 201));
            dialog = null;
        });
        this.contentPane.add(this.btnClose);
        this.getRootPane().setDefaultButton(this.btnClose);
        this.btnCancel = new JButton(BSFinder.resourceManager.getString("btnCancel.text"));
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(event -> {
            if (this.bootp != null) {
                this.bootp.abortBootPUpdate();
            }
            this.setVisible(false);
            this.dispatchEvent(new WindowEvent(this, 201));
            dialog = null;
        });
        sl_contentPane.putConstraint("North", (Component)this.btnCancel, 0, "North", (Component)this.btnClose);
        sl_contentPane.putConstraint("East", (Component)this.btnCancel, -10, "West", (Component)this.btnClose);
        this.contentPane.add(this.btnCancel);
        this.btnProgram = new JButton(BSFinder.resourceManager.getString("btnProgram.text"));
        if (!this.fileExists(this.selectedFile.getAbsolutePath()).booleanValue()) {
            this.btnProgram.setEnabled(false);
        }
        this.btnProgram.addActionListener(event -> {
            try {
                this.bootp = new Bootp(dialog, boardList, this.selectedFile);
                Thread thread = new Thread(this.bootp);
                thread.start();
            }
            catch (IOException e1) {
                this.setMessage("MBootServer.message.fileErr");
                this.setProgrammingActive(false);
                this.bootp = null;
            }
        });
        sl_contentPane.putConstraint("North", (Component)this.btnProgram, 0, "North", (Component)this.btnClose);
        sl_contentPane.putConstraint("East", (Component)this.btnProgram, -10, "West", (Component)this.btnCancel);
        this.contentPane.add(this.btnProgram);
        this.lblState = new JLabel("");
        sl_contentPane.putConstraint("West", (Component)this.lblState, -150, "East", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)this.lblState, -5, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)this.lblState, 0, "East", (Component)this.contentPane);
        this.contentPane.add(this.lblState);
        JSeparator SepVert = new JSeparator();
        sl_contentPane.putConstraint("North", (Component)SepVert, -20, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("West", (Component)SepVert, -2, "West", (Component)this.lblState);
        sl_contentPane.putConstraint("South", (Component)SepVert, 0, "South", (Component)this.contentPane);
        SepVert.setOrientation(1);
        this.contentPane.add(SepVert);
        this.lblMessage = new JLabel("");
        sl_contentPane.putConstraint("West", (Component)this.lblMessage, 10, "West", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)this.lblMessage, -5, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)this.lblMessage, -2, "East", (Component)SepVert);
        this.contentPane.add(this.lblMessage);
        JSeparator SepHorz = new JSeparator();
        sl_contentPane.putConstraint("South", (Component)this.btnClose, -20, "South", (Component)SepHorz);
        sl_contentPane.putConstraint("West", (Component)SepHorz, 0, "West", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)SepHorz, -1, "North", (Component)SepVert);
        sl_contentPane.putConstraint("East", (Component)SepHorz, 0, "East", (Component)this.contentPane);
        this.contentPane.add(SepHorz);
        JScrollPane scrollPane = new JScrollPane();
        sl_contentPane.putConstraint("North", (Component)scrollPane, 10, "South", (Component)lblLogo);
        sl_contentPane.putConstraint("West", (Component)scrollPane, 10, "West", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)scrollPane, -20, "North", (Component)this.btnClose);
        sl_contentPane.putConstraint("East", (Component)scrollPane, -10, "East", (Component)this.contentPane);
        this.contentPane.add(scrollPane);
        this.defaultModel = new DefaultTableModel(new Object[0][], new String[]{BSFinder.resourceManager.getString("DevName"), BSFinder.resourceManager.getString("MAC"), BSFinder.resourceManager.getString("IP"), BSFinder.resourceManager.getString("Progress")}){
            private static final long serialVersionUID = 1L;
            Class[] columnTypes;
            boolean[] columnEditables;
            {
                this.columnTypes = new Class[]{String.class, String.class, String.class, Integer.class};
                this.columnEditables = new boolean[4];
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.columnEditables[column];
            }
        };
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setModel(this.defaultModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.table.setDefaultRenderer(Integer.class, new UpdateTableCellRenderer());
        scrollPane.setViewportView(this.table);
        this.addBoards(boardList);
    }

    private void addBoards(List<Board> boardList) {
        ListIterator<Board> itBoard = boardList.listIterator();
        Integer i = 0;
        while (itBoard.hasNext()) {
            Board board = itBoard.next();
            DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
            tableModel.addRow(new Object[]{board.getAppTitleAsString(), board.getMacAsString(), board.getIpAddr().getHostAddress(), -2});
            i = i + 1;
        }
    }

    public void setProgrammingActive(boolean isActive) {
        if (isActive) {
            this.btnCancel.setEnabled(true);
            this.btnProgram.setEnabled(false);
            this.btnClose.setEnabled(false);
        } else {
            this.btnCancel.setEnabled(false);
            this.btnProgram.setEnabled(true);
            this.btnClose.setEnabled(true);
        }
    }

    public void setMessage(String text) {
        String result = "";
        try {
            result = BSFinder.resourceManager.getString(text);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.lblMessage.setText(result);
    }

    public void setState(String text) {
        String result = "";
        try {
            result = BSFinder.resourceManager.getString(text);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.lblState.setText(result);
    }
}

