/*
 * Decompiled with CFR 0.152.
 */
package com.brennenstuhl.gui;

import com.brennenstuhl.gui.BSFinder;
import com.brennenstuhl.utils.Constants;
import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.BSChartEditor;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public class BSChartPanel
extends ChartPanel {
    private static final long serialVersionUID = -7850106038401659988L;
    public static final int DEFAULT_WIDTH = 1024;
    public static final int DEFAULT_HEIGHT = 576;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 1280;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 720;
    private static final String SAVE_AS_CSV_COMMAND = "SAVE_AS_CSV";
    private static final String RESET_COMMAND = "RESET";
    private Constants.ChartMode chartMode = Constants.ChartMode.H24;

    public BSChartPanel(Constants.ChartMode chartMode, JFreeChart chart) {
        super(chart, 1024, 576, 300, 200, 1280, 720, true, true, true, true, true, true);
        this.setRangeZoomable(false);
        this.chartMode = chartMode;
        this.setMouseWheelEnabled(true);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JMenuItem printItem;
        JPopupMenu result = new JPopupMenu(String.valueOf(localizationResources.getString("Chart")) + ":");
        boolean separator = false;
        if (properties) {
            JMenuItem propertiesItem = new JMenuItem(localizationResources.getString("Properties..."));
            propertiesItem.setActionCommand("PROPERTIES");
            propertiesItem.addActionListener((ActionListener)((Object)this));
            result.add(propertiesItem);
            separator = true;
        }
        if (copy) {
            if (separator) {
                result.addSeparator();
            }
            JMenuItem copyItem = new JMenuItem(localizationResources.getString("Copy"));
            copyItem.setActionCommand("COPY");
            copyItem.addActionListener((ActionListener)((Object)this));
            result.add(copyItem);
            boolean bl = separator = !save;
        }
        if (save) {
            if (separator) {
                result.addSeparator();
            }
            JMenu saveSubMenu = new JMenu(localizationResources.getString("Save_as"));
            JMenuItem pngItem = new JMenuItem(localizationResources.getString("PNG..."));
            pngItem.setActionCommand("SAVE_AS_PNG");
            pngItem.addActionListener((ActionListener)((Object)this));
            saveSubMenu.add(pngItem);
            JMenuItem pdfItem = new JMenuItem(localizationResources.getString("PDF..."));
            pdfItem.setActionCommand("SAVE_AS_PDF");
            pdfItem.addActionListener((ActionListener)((Object)this));
            saveSubMenu.add(pdfItem);
            JMenuItem csvItem = new JMenuItem(BSFinder.resourceManager.getString("CSV..."));
            csvItem.setActionCommand(SAVE_AS_CSV_COMMAND);
            csvItem.addActionListener((ActionListener)((Object)this));
            saveSubMenu.add(csvItem);
            result.add(saveSubMenu);
            separator = true;
        }
        if (print) {
            if (separator) {
                result.addSeparator();
            }
            printItem = new JMenuItem(localizationResources.getString("Print..."));
            printItem.setActionCommand("PRINT");
            printItem.addActionListener((ActionListener)((Object)this));
            result.add(printItem);
            separator = true;
        }
        if (separator) {
            result.addSeparator();
        }
        printItem = new JMenuItem(BSFinder.resourceManager.getString("Reset..."));
        printItem.setActionCommand(RESET_COMMAND);
        printItem.addActionListener((ActionListener)((Object)this));
        result.add(printItem);
        return result;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("PROPERTIES")) {
            this.doEditChartProperties();
        } else if (command.equals("COPY")) {
            this.doCopy();
        } else if (command.equals(SAVE_AS_CSV_COMMAND)) {
            this.saveAsCSV();
        } else if (command.equals("SAVE_AS_PNG")) {
            try {
                this.doSaveAs();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "I/O error occurred.", "Save As PNG", 2);
            }
        } else if (command.equals("SAVE_AS_PDF")) {
            this.saveAsPDF();
        } else if (command.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (command.equals(RESET_COMMAND)) {
            this.resetChart();
        }
    }

    public void resetChart() {
        this.restoreAutoDomainBounds();
        XYPlot p = this.getChart().getXYPlot();
        p.getRangeAxis().setRange(0.07, 15000.0);
        p.getRangeAxis().setDefaultAutoRange(new Range(0.07, 15000.0));
    }

    private void saveAsCSV() {
        File file = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.getDefaultDirectoryForSaveAs());
        FileNameExtensionFilter filter = new FileNameExtensionFilter(BSFinder.resourceManager.getString("CSV_Files"), "csv");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            String fileExists;
            int response;
            String filename = fileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !filename.endsWith(".csv")) {
                filename = String.valueOf(filename) + ".csv";
            }
            if ((file = new File(filename)).exists() && (response = JOptionPane.showConfirmDialog((Component)((Object)this), fileExists = localizationResources.getString("FILE_EXISTS_CONFIRM_OVERWRITE"), "Save As PDF", 2)) == 2) {
                file = null;
            }
        }
        if (file != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("\"ID\";\"TIME (UNIX ms)\";\"POWER(1 unit = 100 mW)\"\n");
            TimeSeriesCollection dataSet = (TimeSeriesCollection)this.getChart().getXYPlot().getDataset(0);
            TimeSeries set = (TimeSeries)dataSet.getSeries().get(0);
            for (Throwable it : set.getItems()) {
                TimeSeriesDataItem i = (TimeSeriesDataItem)it;
                if (i.getValue() == null) continue;
                sb.append(i.getPeriod().getFirstMillisecond());
                sb.append(";");
                sb.append(10.0 * i.getValue().doubleValue());
                sb.append("\n");
            }
            try {
                Throwable it;
                it = null;
                Iterator iterator = null;
                try (PrintWriter out = new PrintWriter(file);){
                    out.print(sb.toString());
                }
                catch (Throwable throwable) {
                    if (it == null) {
                        it = throwable;
                    } else if (it != throwable) {
                        it.addSuppressed(throwable);
                    }
                    throw it;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveAsPDF() {
        File file = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.getDefaultDirectoryForSaveAs());
        FileNameExtensionFilter filter = new FileNameExtensionFilter(localizationResources.getString("PDF_Files"), "pdf");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            String fileExists;
            int response;
            String filename = fileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !filename.endsWith(".pdf")) {
                filename = String.valueOf(filename) + ".pdf";
            }
            if ((file = new File(filename)).exists() && (response = JOptionPane.showConfirmDialog((Component)((Object)this), fileExists = localizationResources.getString("FILE_EXISTS_CONFIRM_OVERWRITE"), "Save As PDF", 2)) == 2) {
                file = null;
            }
        }
        if (file != null) {
            float width = this.getWidth();
            float height = this.getHeight();
            try (Document document = new Document((Rectangle)new RectangleReadOnly(width, height), 10.0f, 10.0f, 10.0f, 10.0f);){
                try {
                    PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                    document.open();
                    PdfContentByte cb = writer.getDirectContent();
                    PdfTemplate template = cb.createTemplate(width, height);
                    PdfGraphics2D g2d = new PdfGraphics2D((PdfContentByte)template, width, height, (FontMapper)new DefaultFontMapper());
                    Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, width, height);
                    this.getChart().draw((Graphics2D)g2d, (Rectangle2D)r2d);
                    cb.addTemplate(template, 0.0f, 0.0f);
                    g2d.dispose();
                }
                catch (DocumentException | FileNotFoundException e) {
                    e.printStackTrace();
                    document.close();
                }
            }
        }
    }

    public void doEditChartProperties() {
        BSChartEditor editor = new BSChartEditor(this.chartMode, this.getChart());
        int result = JOptionPane.showConfirmDialog((Component)((Object)this), editor, localizationResources.getString("Chart_Properties"), 2, -1);
        if (result == 0) {
            editor.updateChart(this.getChart());
        }
    }

    public boolean is24h() {
        return this.chartMode.equals((Object)Constants.ChartMode.H24);
    }

    public boolean isEmpty() {
        TimeSeriesCollection dataSet = (TimeSeriesCollection)this.getChart().getXYPlot().getDataset(0);
        TimeSeries set = (TimeSeries)dataSet.getSeries().get(0);
        return set.isEmpty();
    }

    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            int panMask = 2;
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("mac os x")) {
                panMask = 8;
            }
            e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), panMask, e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.getPopupMenu() != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
        super.mouseReleased(e);
    }
}

